/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.manager;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.Predicate;
import org.mule.extension.introspection.Operation;
import org.mule.extension.runtime.ConfigurationInstanceProvider;
import org.mule.extension.runtime.OperationContext;
import org.mule.extension.runtime.OperationExecutor;
import org.mule.module.extension.internal.manager.ConfigurationInstanceWrapper;
import org.mule.util.CollectionUtils;
import org.mule.util.Preconditions;

final class ConfigurationStateTracker {
    private final Map<String, ConfigurationInstanceWrapper<?>> configurationInstances = new ConcurrentHashMap();
    private final Map<String, ConfigurationInstanceProvider> configurationInstanceProviders = new ConcurrentHashMap<String, ConfigurationInstanceProvider>();

    ConfigurationStateTracker() {
    }

    <C> void registerInstanceProvider(String providerName, ConfigurationInstanceProvider<C> configurationInstanceProvider) {
        this.configurationInstanceProviders.put(providerName, configurationInstanceProvider);
    }

    <C> void registerInstance(String instanceName, C configurationInstance) {
        this.configurationInstances.put(instanceName, new ConfigurationInstanceWrapper<C>(instanceName, configurationInstance));
    }

    Map<String, ConfigurationInstanceProvider> getConfigurationInstanceProviders() {
        return ImmutableMap.copyOf(this.configurationInstanceProviders);
    }

    <C> OperationExecutor getOperationExecutor(C configurationInstance, OperationContext operationContext) {
        ConfigurationInstanceWrapper<C> wrapper = this.locateConfigurationInstanceWrapper(configurationInstance);
        return wrapper.getOperationExecutor(operationContext.getOperation());
    }

    <C> void registerOperationExecutor(Operation operation, C configurationInstance, OperationExecutor executor) {
        ConfigurationInstanceWrapper<C> wrapper = this.locateConfigurationInstanceWrapper(configurationInstance);
        wrapper.registerOperationExecutor(operation, executor);
    }

    private <C> ConfigurationInstanceWrapper<C> locateConfigurationInstanceWrapper(final C configurationInstance) {
        ConfigurationInstanceWrapper wrapper = (ConfigurationInstanceWrapper)CollectionUtils.find(this.configurationInstances.values(), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return ((ConfigurationInstanceWrapper)object).getConfigurationInstance() == configurationInstance;
            }
        });
        Preconditions.checkState((wrapper != null ? 1 : 0) != 0, (String)"Can't create an operation executor for an unregistered configuration instance");
        return wrapper;
    }
}

