/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.introspection;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.mule.extension.introspection.DataType;
import org.mule.extension.introspection.Parameter;
import org.mule.module.extension.internal.introspection.AbstractImmutableCapableDescribed;
import org.mule.util.Preconditions;

final class ImmutableParameter
extends AbstractImmutableCapableDescribed
implements Parameter {
    private static final Set<String> reservedNames = ImmutableSet.builder().add((Object)"name").build();
    private final DataType type;
    private final boolean required;
    private final boolean dynamic;
    private final Object defaultValue;

    protected ImmutableParameter(String name, String description, DataType type, boolean required, boolean dynamic, Object defaultValue, Set<Object> capabilities) {
        super(name, description, capabilities);
        if (reservedNames.contains(name)) {
            throw new IllegalArgumentException(String.format("Extension parameter cannot have the name ['%s'] since it's a reserved one", name));
        }
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Parameters must have a type");
        if (required && defaultValue != null) {
            throw new IllegalStateException("If a parameter is required then it cannot have a default value");
        }
        this.type = type;
        this.required = required;
        this.dynamic = dynamic;
        this.defaultValue = defaultValue;
    }

    public DataType getType() {
        return this.type;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

