/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.schema.builder;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.SubTypesModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.extension.api.declaration.type.TypeUtils;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterModel;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.internal.capability.xml.schema.builder.ComplexTypeHolder;
import org.mule.runtime.module.extension.internal.capability.xml.schema.builder.SchemaBuilder;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ComplexContent;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ComplexType;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ExplicitGroup;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ExtensionType;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.LocalComplexType;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ObjectFactory;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.TopLevelComplexType;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.TopLevelElement;
import org.mule.runtime.module.extension.internal.xml.SchemaConstants;

final class ObjectTypeSchemaDelegate {
    private final Map<String, ComplexTypeHolder> registeredComplexTypesHolders = new LinkedHashMap<String, ComplexTypeHolder>();
    private final Map<String, TopLevelElement> registeredGlobalElementTypes = new LinkedHashMap<String, TopLevelElement>();
    private final ObjectFactory objectFactory = new ObjectFactory();
    private final SchemaBuilder builder;
    private final DslSyntaxResolver dsl;

    ObjectTypeSchemaDelegate(SchemaBuilder builder) {
        this.builder = builder;
        this.dsl = builder.getDslResolver();
    }

    void generatePojoElement(ObjectType type, DslElementSyntax paramSyntax, ParameterDslConfiguration paramDsl, String description, List<TopLevelElement> all) {
        if (paramSyntax.supportsChildDeclaration()) {
            if (this.builder.isImported((MetadataType)type)) {
                this.addImportedTypeElement(paramSyntax, description, (MetadataType)type, all);
            } else if (paramSyntax.isWrapped()) {
                this.declareRefToType(type, paramSyntax, description, all);
            } else {
                this.declareTypeInline(type, paramSyntax, description, all);
            }
        }
        Optional typeDsl = this.builder.getDslResolver().resolve((MetadataType)type);
        if (paramDsl.allowsReferences() && typeDsl.isPresent() && ((DslElementSyntax)typeDsl.get()).supportsTopLevelDeclaration() && !this.builder.isImported((MetadataType)type)) {
            this.registerPojoType((MetadataType)type, description);
        }
    }

    private void declareTypeInline(ObjectType objectType, DslElementSyntax paramDsl, String description, List<TopLevelElement> all) {
        this.registerPojoComplexType(objectType, null, description);
        String typeName = this.getBaseTypeName((MetadataType)objectType);
        QName localQName = new QName(paramDsl.getNamespaceUri(), typeName, paramDsl.getNamespace());
        this.addChildElementTypeExtension(localQName, description, paramDsl.getElementName(), !paramDsl.supportsAttributeDeclaration(), all);
    }

    private void declareRefToType(ObjectType objectType, DslElementSyntax paramDsl, String description, List<TopLevelElement> all) {
        this.registerPojoSubtypes((MetadataType)objectType, this.builder.getTypesMapping().getSubTypes(objectType));
        this.addAbstractTypeRef(paramDsl, description, (MetadataType)objectType, all);
    }

    private void addChildElementTypeExtension(QName base, String description, String name, boolean required, List<TopLevelElement> all) {
        TopLevelElement objectElement = this.builder.createTopLevelElement(name, required ? BigInteger.ONE : BigInteger.ZERO, "1");
        objectElement.setAnnotation(this.builder.createDocAnnotation(description));
        objectElement.setComplexType(this.createTypeExtension(base));
        all.add(objectElement);
    }

    private void addImportedTypeElement(DslElementSyntax paramDsl, String description, MetadataType metadataType, List<TopLevelElement> all) {
        DslElementSyntax typeDsl = (DslElementSyntax)this.builder.getDslResolver().resolve(metadataType).orElseThrow(() -> new IllegalArgumentException(String.format("The given type [%s] is not eligible for Import", ExtensionMetadataTypeUtils.getId((MetadataType)metadataType))));
        if (paramDsl.isWrapped()) {
            TopLevelElement objectElement = this.builder.createTopLevelElement(paramDsl.getElementName(), BigInteger.ZERO, "1");
            objectElement.setComplexType(new LocalComplexType());
            objectElement.setAnnotation(this.builder.createDocAnnotation(description));
            if (typeDsl.isWrapped()) {
                objectElement.getComplexType().setSequence(this.builder.createTypeRefChoiceLocalOrGlobal(typeDsl, metadataType, BigInteger.ZERO, "unbounded"));
            } else {
                ExplicitGroup sequence = new ExplicitGroup();
                sequence.setMinOccurs(BigInteger.ONE);
                sequence.setMaxOccurs("1");
                QName refQName = new QName(paramDsl.getNamespaceUri(), ObjectTypeSchemaDelegate.getAbstractElementName(typeDsl), paramDsl.getNamespace());
                sequence.getParticle().add(this.objectFactory.createElement(this.builder.createRefElement(refQName, false)));
                objectElement.getComplexType().setSequence(sequence);
            }
            all.add(objectElement);
        } else {
            QName extensionBase = new QName(typeDsl.getNamespaceUri(), NameUtils.sanitizeName((String)ExtensionMetadataTypeUtils.getId((MetadataType)metadataType)), typeDsl.getNamespace());
            this.addChildElementTypeExtension(extensionBase, description, paramDsl.getElementName(), !paramDsl.supportsAttributeDeclaration(), all);
        }
    }

    private void addAbstractTypeRef(DslElementSyntax paramDsl, String description, MetadataType metadataType, List<TopLevelElement> all) {
        TopLevelElement objectElement = this.builder.createTopLevelElement(paramDsl.getElementName(), paramDsl.supportsAttributeDeclaration() ? BigInteger.ZERO : BigInteger.ONE, "1");
        objectElement.setAnnotation(this.builder.createDocAnnotation(description));
        objectElement.setComplexType(this.createComplexTypeWithAbstractElementRef(metadataType));
        all.add(objectElement);
    }

    private LocalComplexType createComplexTypeWithAbstractElementRef(MetadataType type) {
        DslElementSyntax typeDsl = (DslElementSyntax)this.builder.getDslResolver().resolve(type).orElseThrow(() -> new IllegalArgumentException(String.format("No element ref can be created for the given type [%s]", ExtensionMetadataTypeUtils.getId((MetadataType)type))));
        LocalComplexType complexType = new LocalComplexType();
        if (typeDsl.isWrapped()) {
            complexType.setChoice(this.builder.createTypeRefChoiceLocalOrGlobal(typeDsl, type, BigInteger.ONE, "1"));
        } else {
            ExplicitGroup sequence = new ExplicitGroup();
            sequence.setMinOccurs(BigInteger.ONE);
            sequence.setMaxOccurs("1");
            sequence.getParticle().add(this.objectFactory.createElement(this.createRefToLocalElement(typeDsl, type)));
            complexType.setSequence(sequence);
        }
        return complexType;
    }

    private TopLevelElement createRefToLocalElement(DslElementSyntax typeDsl, MetadataType metadataType) {
        this.registerPojoType(metadataType, "");
        QName qName = new QName(typeDsl.getNamespaceUri(), ObjectTypeSchemaDelegate.getAbstractElementName(typeDsl), typeDsl.getNamespace());
        return this.builder.createRefElement(qName, false);
    }

    String registerPojoType(MetadataType metadataType, String description) {
        return this.registerPojoType(metadataType, null, description);
    }

    private String registerPojoType(MetadataType type, MetadataType baseType, String description) {
        if (!this.builder.isImported(type)) {
            this.registerPojoComplexType((ObjectType)type, (ObjectType)baseType, description);
            Optional typeDsl = this.builder.getDslResolver().resolve(type);
            if (typeDsl.isPresent() && this.shouldRegisterTypeAsElement(type, (DslElementSyntax)typeDsl.get())) {
                this.registerPojoGlobalElements((DslElementSyntax)typeDsl.get(), (ObjectType)type, (ObjectType)baseType, description);
            }
        }
        return this.getBaseTypeName(type);
    }

    private boolean shouldRegisterTypeAsElement(MetadataType type, DslElementSyntax typeDsl) {
        return typeDsl.supportsTopLevelDeclaration() || typeDsl.isWrapped() || type instanceof ObjectType && !this.builder.getTypesMapping().getSuperTypes((ObjectType)type).isEmpty();
    }

    private ComplexType registerPojoComplexType(ObjectType type, ObjectType baseType, String description) {
        String typeId = ExtensionMetadataTypeUtils.getId((MetadataType)type);
        if (this.registeredComplexTypesHolders.get(typeId) != null) {
            return this.registeredComplexTypesHolders.get(typeId).getComplexType();
        }
        QName base = this.getComplexTypeBase(baseType);
        Collection fields = baseType == null ? type.getFields() : (Collection)type.getFields().stream().filter(field -> !baseType.getFields().stream().anyMatch(other -> other.getKey().getName().getLocalPart().equals(field.getKey().getName().getLocalPart()))).collect(Collectors.toList());
        ComplexType complexType = this.declarePojoAsType(type, base, description, fields);
        this.builder.getSchema().getSimpleTypeOrComplexTypeOrGroup().add(complexType);
        return complexType;
    }

    private QName getComplexTypeBase(ObjectType baseType) {
        Optional baseDsl = this.builder.getDslResolver().resolve((MetadataType)baseType);
        if (!baseDsl.isPresent()) {
            return SchemaConstants.MULE_ABSTRACT_EXTENSION_TYPE;
        }
        return new QName(((DslElementSyntax)baseDsl.get()).getNamespaceUri(), this.getBaseTypeName((MetadataType)baseType), ((DslElementSyntax)baseDsl.get()).getNamespace());
    }

    private ComplexType declarePojoAsType(ObjectType metadataType, QName base, String description, Collection<ObjectFieldType> fields) {
        TopLevelComplexType complexType = new TopLevelComplexType();
        this.registeredComplexTypesHolders.put(ExtensionMetadataTypeUtils.getId((MetadataType)metadataType), new ComplexTypeHolder(complexType, (MetadataType)metadataType));
        complexType.setName(NameUtils.sanitizeName((String)ExtensionMetadataTypeUtils.getId((MetadataType)metadataType)));
        complexType.setAnnotation(this.builder.createDocAnnotation(description));
        ComplexContent complexContent = new ComplexContent();
        complexType.setComplexContent(complexContent);
        ExtensionType extension = new ExtensionType();
        extension.setBase(base);
        complexContent.setExtension(extension);
        DslElementSyntax typeDsl = (DslElementSyntax)this.dsl.resolve((MetadataType)metadataType).get();
        LinkedList childElements = new LinkedList();
        fields.forEach(field -> {
            String fieldName = field.getKey().getName().getLocalPart();
            DslElementSyntax fieldDsl = typeDsl.getContainedElement(fieldName).orElse(null);
            if (ExtensionMetadataTypeUtils.isParameterGroup((MetadataType)field)) {
                this.declareGroupedFields(extension, childElements, (ObjectFieldType)field);
            } else {
                this.declareObjectField(fieldDsl, (ObjectFieldType)field, extension, childElements);
            }
        });
        if (!childElements.isEmpty()) {
            ExplicitGroup all = new ExplicitGroup();
            all.setMaxOccurs("1");
            boolean requiredChilds = childElements.stream().anyMatch(this.builder::isRequired);
            all.setMinOccurs(requiredChilds ? BigInteger.ONE : BigInteger.ZERO);
            childElements.forEach(p -> all.getParticle().add(this.objectFactory.createElement((TopLevelElement)p)));
            extension.setSequence(all);
        }
        return complexType;
    }

    private void declareGroupedFields(ExtensionType extension, List<TopLevelElement> childElements, ObjectFieldType field) {
        DslElementSyntax groupDsl = (DslElementSyntax)this.dsl.resolve(field.getValue()).get();
        ((ObjectType)field.getValue()).getFields().forEach(subField -> {
            DslElementSyntax subFieldDsl = groupDsl.getContainedElement(subField.getKey().getName().getLocalPart()).orElse(null);
            this.declareObjectField(subFieldDsl, (ObjectFieldType)subField, extension, childElements);
        });
    }

    private void declareObjectField(DslElementSyntax fieldDsl, ObjectFieldType field, ExtensionType extension, List<TopLevelElement> all) {
        String id;
        ImmutableParameterModel parameter = this.asParameter(field);
        if (fieldDsl == null) {
            fieldDsl = this.dsl.resolve((ParameterModel)parameter);
        }
        if ((id = ExtensionMetadataTypeUtils.getId((MetadataType)field.getValue())).equals(TlsContextFactory.class.getName())) {
            this.builder.addTlsSupport(extension, all);
            return;
        }
        this.builder.declareAsParameter(field.getValue(), extension, (ParameterModel)parameter, fieldDsl, all);
    }

    private void registerPojoGlobalElements(DslElementSyntax typeDsl, ObjectType type, ObjectType baseType, String description) {
        if (this.registeredGlobalElementTypes.containsKey(this.globalTypeKey(typeDsl))) {
            return;
        }
        QName typeQName = this.getTypeQName(typeDsl, (MetadataType)type);
        TopLevelElement abstractElement = this.registerAbstractElement(typeQName, typeDsl, baseType);
        if (typeDsl.supportsTopLevelDeclaration() || typeDsl.supportsChildDeclaration() && typeDsl.isWrapped() || !this.builder.getTypesMapping().getSuperTypes(type).isEmpty()) {
            this.registerConcreteGlobalElement(typeDsl, description, abstractElement.getName(), typeQName);
        }
    }

    QName getTypeQName(DslElementSyntax typeDsl, MetadataType type) {
        return new QName(this.builder.getSchema().getTargetNamespace(), this.getBaseTypeName(type), typeDsl.getNamespace());
    }

    TopLevelElement registerAbstractElement(MetadataType type, DslElementSyntax typeDsl) {
        return this.registerAbstractElement(this.getTypeQName(typeDsl, type), typeDsl, null);
    }

    private TopLevelElement registerAbstractElement(QName typeQName, DslElementSyntax typeDsl, ObjectType baseType) {
        TopLevelElement element = this.registeredGlobalElementTypes.get(typeDsl.getNamespace() + ObjectTypeSchemaDelegate.getAbstractElementName(typeDsl));
        if (element != null) {
            return element;
        }
        Optional baseDsl = this.builder.getDslResolver().resolve((MetadataType)baseType);
        if (typeDsl.isWrapped()) {
            this.createGlobalMuleExtensionAbstractElement(typeQName, typeDsl, baseDsl);
        }
        TopLevelElement abstractElement = new TopLevelElement();
        abstractElement.setName(ObjectTypeSchemaDelegate.getAbstractElementName(typeDsl));
        abstractElement.setAbstract(true);
        if (!typeDsl.supportsTopLevelDeclaration()) {
            abstractElement.setType(typeQName);
        }
        if (baseDsl.isPresent() || typeDsl.supportsTopLevelDeclaration()) {
            QName substitutionGroup = this.getAbstractElementSubstitutionGroup(typeDsl, baseDsl);
            abstractElement.setSubstitutionGroup(substitutionGroup);
        }
        this.builder.getSchema().getSimpleTypeOrComplexTypeOrGroup().add(abstractElement);
        this.registeredGlobalElementTypes.put(typeDsl.getNamespace() + ObjectTypeSchemaDelegate.getAbstractElementName(typeDsl), abstractElement);
        return abstractElement;
    }

    private QName getAbstractElementSubstitutionGroup(DslElementSyntax typeDsl, Optional<DslElementSyntax> baseDsl) {
        QName substitutionGroup;
        if (baseDsl.isPresent()) {
            DslElementSyntax base = baseDsl.get();
            String abstractElementName = typeDsl.supportsTopLevelDeclaration() ? ObjectTypeSchemaDelegate.getGlobalAbstractName(base) : ObjectTypeSchemaDelegate.getAbstractElementName(base);
            substitutionGroup = new QName(base.getNamespaceUri(), abstractElementName, base.getNamespace());
        } else {
            substitutionGroup = typeDsl.isWrapped() ? new QName(typeDsl.getNamespaceUri(), ObjectTypeSchemaDelegate.getGlobalAbstractName(typeDsl), typeDsl.getNamespace()) : SchemaConstants.MULE_ABSTRACT_EXTENSION;
        }
        return substitutionGroup;
    }

    private void createGlobalMuleExtensionAbstractElement(QName typeQName, DslElementSyntax typeDsl, Optional<DslElementSyntax> baseDsl) {
        QName globalSubGroup;
        if (baseDsl.isPresent()) {
            DslElementSyntax base = baseDsl.get();
            globalSubGroup = new QName(base.getNamespaceUri(), ObjectTypeSchemaDelegate.getGlobalAbstractName(base), base.getNamespace());
        } else {
            globalSubGroup = SchemaConstants.MULE_ABSTRACT_EXTENSION;
        }
        TopLevelElement abstractElement = new TopLevelElement();
        abstractElement.setName(ObjectTypeSchemaDelegate.getGlobalAbstractName(typeDsl));
        abstractElement.setSubstitutionGroup(globalSubGroup);
        abstractElement.setAbstract(true);
        if (!typeDsl.supportsTopLevelDeclaration()) {
            abstractElement.setType(typeQName);
        }
        this.builder.getSchema().getSimpleTypeOrComplexTypeOrGroup().add(abstractElement);
    }

    void registerConcreteGlobalElement(DslElementSyntax typeDsl, String description, String abstractElementName, QName typeQName) {
        if (this.registeredGlobalElementTypes.containsKey(this.globalTypeKey(typeDsl))) {
            return;
        }
        TopLevelElement objectElement = new TopLevelElement();
        objectElement.setName(typeDsl.getElementName());
        objectElement.setSubstitutionGroup(new QName(typeDsl.getNamespaceUri(), abstractElementName, typeDsl.getNamespace()));
        objectElement.setAnnotation(this.builder.createDocAnnotation(description));
        objectElement.setComplexType(this.createTypeExtension(typeQName));
        if (typeDsl.supportsTopLevelDeclaration()) {
            objectElement.getComplexType().getComplexContent().getExtension().getAttributeOrAttributeGroup().add(this.builder.createNameAttribute(false));
        }
        this.builder.getSchema().getSimpleTypeOrComplexTypeOrGroup().add(objectElement);
        this.registeredGlobalElementTypes.put(this.globalTypeKey(typeDsl), objectElement);
    }

    private String globalTypeKey(DslElementSyntax typeDsl) {
        return typeDsl.getNamespace() + typeDsl.getElementName();
    }

    private ImmutableParameterModel asParameter(ObjectFieldType field) {
        return new ImmutableParameterModel(field.getKey().getName().getLocalPart(), "", field.getValue(), false, field.isRequired(), TypeUtils.getExpressionSupport((MetadataType)field), MetadataTypeUtils.getDefaultValue((MetadataType)field).orElse(null), TypeUtils.getParameterRole((MetadataType)field), ParameterDslConfiguration.getDefaultInstance(), null, (LayoutModel)TypeUtils.getLayoutModel((MetadataType)field).orElse(null), Collections.emptySet());
    }

    void registerPojoSubtypes(SubTypesModel subTypesModel) {
        this.registerPojoSubtypes((MetadataType)subTypesModel.getBaseType(), subTypesModel.getSubTypes());
    }

    void registerPojoSubtypes(MetadataType baseType, Collection<ObjectType> subTypes) {
        if (!this.builder.isImported(baseType)) {
            this.registerPojoType(baseType, "");
        }
        subTypes.forEach(subtype -> this.registerPojoType((MetadataType)subtype, baseType, ""));
    }

    LocalComplexType createTypeExtension(QName base) {
        LocalComplexType complexType = new LocalComplexType();
        ComplexContent complexContent = new ComplexContent();
        complexType.setComplexContent(complexContent);
        ExtensionType extension = new ExtensionType();
        extension.setBase(base);
        complexContent.setExtension(extension);
        return complexType;
    }

    private String getBaseTypeName(MetadataType type) {
        return NameUtils.sanitizeName((String)ExtensionMetadataTypeUtils.getId((MetadataType)type));
    }

    static String getGlobalAbstractName(DslElementSyntax dsl) {
        return "global-" + ObjectTypeSchemaDelegate.getAbstractElementName(dsl);
    }

    static String getAbstractElementName(DslElementSyntax dsl) {
        return "abstract-" + dsl.getElementName();
    }
}

