/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.schema.builder;

import java.util.List;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.module.extension.internal.capability.xml.schema.builder.ExecutableTypeSchemaDelegate;
import org.mule.runtime.module.extension.internal.capability.xml.schema.builder.SchemaBuilder;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ExplicitGroup;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ExtensionType;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.TopLevelElement;
import org.mule.runtime.module.extension.internal.xml.SchemaConstants;

class SourceSchemaDelegate
extends ExecutableTypeSchemaDelegate {
    SourceSchemaDelegate(SchemaBuilder builder) {
        super(builder);
    }

    void registerMessageSource(SourceModel sourceModel, DslElementSyntax dslSyntax) {
        String typeName = StringUtils.capitalize((String)sourceModel.getName()) + "Type";
        this.registerSourceElement(sourceModel, typeName, dslSyntax);
        this.registerSourceType(typeName, sourceModel, dslSyntax);
    }

    private void registerSourceElement(SourceModel sourceModel, String typeName, DslElementSyntax dslSyntax) {
        TopLevelElement element = new TopLevelElement();
        element.setName(dslSyntax.getElementName());
        element.setType(new QName(this.builder.getSchema().getTargetNamespace(), typeName));
        element.setAnnotation(this.builder.createDocAnnotation(sourceModel.getDescription()));
        element.setSubstitutionGroup(SchemaConstants.MULE_ABSTRACT_MESSAGE_SOURCE);
        this.builder.getSchema().getSimpleTypeOrComplexTypeOrGroup().add(element);
    }

    private void registerSourceType(String name, SourceModel sourceModel, DslElementSyntax dslSyntax) {
        ExtensionType sourceType = this.createExecutableType(name, SchemaConstants.MULE_ABSTRACT_MESSAGE_SOURCE_TYPE, dslSyntax);
        this.initialiseSequence(sourceType);
        ExplicitGroup sequence = sourceType.getSequence();
        this.builder.addInfrastructureParameters(sourceType, (ParameterizedModel)sourceModel, sequence);
        List<ParameterGroupModel> inlineGroupedParameters = this.getInlineGroups((ParameterizedModel)sourceModel);
        sourceModel.getErrorCallback().ifPresent(cb -> inlineGroupedParameters.addAll(this.getInlineGroups((ParameterizedModel)cb)));
        sourceModel.getSuccessCallback().ifPresent(cb -> inlineGroupedParameters.addAll(this.getInlineGroups((ParameterizedModel)cb)));
        List<ParameterModel> flatParameters = sourceModel.getAllParameterModels().stream().filter(p -> inlineGroupedParameters.stream().noneMatch(g -> g.getParameterModels().contains(p))).collect(Collectors.toList());
        this.registerParameters(sourceType, flatParameters);
        inlineGroupedParameters.forEach(g -> this.builder.addInlineParameterGroup((ParameterGroupModel)g, sourceType.getSequence()));
    }

    private List<ParameterGroupModel> getInlineGroups(ParameterizedModel model) {
        return model.getParameterGroupModels().stream().filter(ParameterGroupModel::isShowInDsl).collect(Collectors.toList());
    }
}

