/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.schema;

import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.lang.StringUtils;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.util.XmlModelUtils;
import org.mule.runtime.module.extension.internal.capability.xml.schema.builder.SchemaBuilder;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.NamespaceFilter;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.Schema;
import org.xml.sax.ContentHandler;

public class SchemaGenerator {
    private void validate(ExtensionModel extensionModel, XmlDslModel xmlDslModel) {
        Preconditions.checkArgument((extensionModel != null ? 1 : 0) != 0, (String)"extension cannot be null");
        Preconditions.checkArgument((xmlDslModel != null ? 1 : 0) != 0, (String)"xml model property cannot be null");
        Preconditions.checkState((!StringUtils.isBlank((String)xmlDslModel.getNamespace()) ? 1 : 0) != 0, (String)"xml model property cannot provide a blank namespace");
    }

    public String generate(ExtensionModel extensionModel, XmlDslModel xmlDslModel, DslResolvingContext dslContext) {
        this.validate(extensionModel, xmlDslModel);
        final SchemaBuilder schemaBuilder = SchemaBuilder.newSchema(extensionModel, xmlDslModel, dslContext);
        new IdempotentExtensionWalker(){

            public void onConfiguration(ConfigurationModel model) {
                schemaBuilder.registerConfigElement(model);
            }

            public void onOperation(OperationModel model) {
                schemaBuilder.registerOperation(model);
            }

            public void onConnectionProvider(ConnectionProviderModel model) {
                schemaBuilder.registerConnectionProviderElement(model);
            }

            public void onSource(SourceModel model) {
                schemaBuilder.registerMessageSource(model);
            }
        }.walk(extensionModel);
        schemaBuilder.registerEnums();
        return this.renderSchema(schemaBuilder.build());
    }

    private String renderSchema(Schema schema) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Schema.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            NamespaceFilter outFilter = new NamespaceFilter("mule", XmlModelUtils.MULE_NAMESPACE_SCHEMA_LOCATION, true);
            OutputFormat format = new OutputFormat();
            format.setIndent(true);
            format.setNewlines(true);
            StringWriter sw = new StringWriter();
            XMLWriter writer = new XMLWriter((Writer)sw, format);
            outFilter.setContentHandler((ContentHandler)writer);
            marshaller.marshal((Object)schema, (ContentHandler)outFilter);
            return sw.toString();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

