/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.schema.model;

import javax.xml.namespace.QName;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.DateType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.module.extension.internal.xml.SchemaConstants;

public final class SchemaTypeConversion {
    public static QName convertType(MetadataType type, ExpressionSupport expressionSupport) {
        final boolean dynamic = ExtensionModelUtils.acceptsExpressions((ExpressionSupport)expressionSupport);
        final Reference qName = new Reference(null);
        type.accept(new MetadataTypeVisitor(){

            public void visitBoolean(BooleanType booleanType) {
                qName.set((Object)(dynamic ? SchemaConstants.EXPRESSION_BOOLEAN : SchemaConstants.SUBSTITUTABLE_BOOLEAN));
            }

            public void visitNumber(NumberType numberType) {
                Class type = JavaTypeUtils.getType((MetadataType)numberType);
                if (this.anyOf(type, Integer.class, Integer.TYPE)) {
                    qName.set((Object)(dynamic ? SchemaConstants.EXPRESSION_INTEGER : SchemaConstants.SUBSTITUTABLE_INT));
                } else if (this.anyOf(type, Double.class, Double.TYPE)) {
                    qName.set((Object)(dynamic ? SchemaConstants.EXPRESSION_DOUBLE : SchemaConstants.SUBSTITUTABLE_DECIMAL));
                } else if (this.anyOf(type, Long.class, Long.TYPE)) {
                    qName.set((Object)(dynamic ? SchemaConstants.EXPRESSION_LONG : SchemaConstants.SUBSTITUTABLE_LONG));
                } else {
                    qName.set((Object)(dynamic ? SchemaConstants.EXPRESSION_DECIMAL : SchemaConstants.SUBSTITUTABLE_DECIMAL));
                }
            }

            public void visitString(StringType stringType) {
                qName.set((Object)(dynamic ? SchemaConstants.EXPRESSION_STRING : SchemaConstants.STRING));
            }

            public void visitDateTime(DateTimeType dateTimeType) {
                this.onDate();
            }

            public void visitDate(DateType dateType) {
                this.onDate();
            }

            public void visitArrayType(ArrayType arrayType) {
                qName.set((Object)(dynamic ? SchemaConstants.EXPRESSION_LIST : SchemaConstants.SUBSTITUTABLE_NAME));
            }

            public void visitObject(ObjectType objectType) {
                if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
                    qName.set((Object)(dynamic ? SchemaConstants.EXPRESSION_MAP : SchemaConstants.SUBSTITUTABLE_MAP));
                } else {
                    this.defaultVisit((MetadataType)objectType);
                }
            }

            protected void defaultVisit(MetadataType metadataType) {
                qName.set((Object)SchemaConstants.STRING);
            }

            private void onDate() {
                qName.set((Object)(dynamic ? SchemaConstants.EXPRESSION_DATE_TIME : SchemaConstants.SUBSTITUTABLE_DATE_TIME));
            }

            private boolean anyOf(Class<Number> type, Class<?> ... targets) {
                for (Class<?> target : targets) {
                    if (!type.equals(target)) continue;
                    return true;
                }
                return false;
            }
        });
        return (QName)qName.get();
    }
}

