/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.resources;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.registry.ServiceRegistry;
import org.mule.runtime.core.registry.SpiServiceRegistry;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.declaration.DescribingContext;
import org.mule.runtime.extension.api.resources.ResourcesGenerator;
import org.mule.runtime.extension.api.resources.spi.GeneratedResourceFactory;
import org.mule.runtime.extension.api.runtime.ExtensionFactory;
import org.mule.runtime.extension.xml.dsl.api.resources.spi.DslResourceFactory;
import org.mule.runtime.module.extension.internal.DefaultDescribingContext;
import org.mule.runtime.module.extension.internal.capability.xml.schema.AnnotationProcessorUtils;
import org.mule.runtime.module.extension.internal.introspection.DefaultExtensionFactory;
import org.mule.runtime.module.extension.internal.introspection.describer.AnnotationsBasedDescriber;
import org.mule.runtime.module.extension.internal.introspection.version.StaticVersionResolver;
import org.mule.runtime.module.extension.internal.introspection.version.VersionResolver;
import org.mule.runtime.module.extension.internal.resources.AnnotationProcessorResourceGenerator;

@SupportedAnnotationTypes(value={"org.mule.runtime.extension.api.annotation.Extension"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedOptions(value={"extension.version"})
public class ExtensionResourcesGeneratorAnnotationProcessor
extends AbstractProcessor {
    public static final String PROCESSING_ENVIRONMENT = "PROCESSING_ENVIRONMENT";
    public static final String EXTENSION_ELEMENT = "EXTENSION_ELEMENT";
    public static final String ROUND_ENVIRONMENT = "ROUND_ENVIRONMENT";
    public static final String EXTENSION_VERSION = "extension.version";
    private final SpiServiceRegistry serviceRegistry = new SpiServiceRegistry();
    private final ExtensionFactory extensionFactory = new DefaultExtensionFactory((ServiceRegistry)this.serviceRegistry, this.getClass().getClassLoader());

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.log("Starting Resources generator for Extensions");
        AnnotationProcessorResourceGenerator generator = new AnnotationProcessorResourceGenerator(this.fetchResourceFactories(), this.processingEnv);
        try {
            this.getExtension(roundEnv).ifPresent(arg_0 -> this.lambda$process$1(roundEnv, (ResourcesGenerator)generator, arg_0));
            return false;
        }
        catch (Exception e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("%s\n%s", e.getMessage(), ExceptionUtils.getFullStackTrace((Throwable)e)));
            throw e;
        }
    }

    private ExtensionModel parseExtension(TypeElement extensionElement, RoundEnvironment roundEnvironment) {
        Class extensionClass = AnnotationProcessorUtils.classFor(extensionElement, this.processingEnv);
        AnnotationsBasedDescriber describer = new AnnotationsBasedDescriber(extensionClass, (VersionResolver)new StaticVersionResolver(this.getVersion(extensionElement.getQualifiedName())));
        DefaultDescribingContext context = new DefaultDescribingContext(extensionClass.getClassLoader());
        context.addParameter(EXTENSION_ELEMENT, (Object)extensionElement);
        context.addParameter(PROCESSING_ENVIRONMENT, (Object)this.processingEnv);
        context.addParameter(ROUND_ENVIRONMENT, (Object)roundEnvironment);
        return this.extensionFactory.createFrom(describer.describe((DescribingContext)context), (DescribingContext)context);
    }

    private Optional<TypeElement> getExtension(RoundEnvironment env) {
        Set<TypeElement> elements = AnnotationProcessorUtils.getTypeElementsAnnotatedWith(Extension.class, env);
        if (elements.size() > 1) {
            String message = String.format("Only one extension is allowed per plugin, however several classes annotated with @%s were found. Offending classes are [%s]", Extension.class.getSimpleName(), Joiner.on((String)", ").join((Iterable)elements.stream().map(TypeElement::getQualifiedName).collect(Collectors.toList())));
            throw new RuntimeException(message);
        }
        return elements.stream().findFirst();
    }

    private void log(String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, message);
    }

    private String getVersion(Name qualifiedName) {
        String extensionVersion = this.processingEnv.getOptions().get(EXTENSION_VERSION);
        if (extensionVersion == null) {
            throw new RuntimeException(String.format("Cannot resolve version for extension %s: option '%s' is missing.", qualifiedName, EXTENSION_VERSION));
        }
        return extensionVersion;
    }

    private List<GeneratedResourceFactory> fetchResourceFactories() {
        return ImmutableList.builder().addAll((Iterable)this.serviceRegistry.lookupProviders(GeneratedResourceFactory.class, this.getClass().getClassLoader())).addAll((Iterable)this.serviceRegistry.lookupProviders(DslResourceFactory.class, this.getClass().getClassLoader())).build();
    }

    private /* synthetic */ void lambda$process$1(RoundEnvironment roundEnv, ResourcesGenerator generator, TypeElement extensionElement) {
        Class extensionClass = AnnotationProcessorUtils.classFor(extensionElement, this.processingEnv);
        ClassUtils.withContextClassLoader((ClassLoader)extensionClass.getClassLoader(), () -> {
            ExtensionModel extensionModel = this.parseExtension(extensionElement, roundEnv);
            generator.generateFor(extensionModel);
        });
    }
}

