/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl.parameter;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.internal.utils.MetadataTypeUtils;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.extension.api.declaration.type.annotation.FlattenedTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.NullSafeTypeAnnotation;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.module.extension.internal.config.dsl.AbstractExtensionObjectFactory;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.ObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.NullSafeValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ObjectBuilderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeExpressionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public class TopLevelParameterObjectFactory
extends AbstractExtensionObjectFactory<Object> {
    private DefaultObjectBuilder builder;
    private Class<Object> objectClass;
    private final ObjectType objectType;
    private final ClassLoader classLoader;

    public TopLevelParameterObjectFactory(ObjectType type, ClassLoader classLoader, MuleContext muleContext) {
        super(muleContext);
        this.classLoader = classLoader;
        this.objectType = type;
        ClassUtils.withContextClassLoader((ClassLoader)classLoader, () -> {
            this.objectClass = JavaTypeUtils.getType((MetadataType)type);
            this.builder = new DefaultObjectBuilder(this.objectClass);
        });
    }

    public Object doGetObject() throws Exception {
        return ClassUtils.withContextClassLoader((ClassLoader)this.classLoader, () -> {
            this.resolveParameters(this.objectType, this.builder);
            this.resolveParameterGroups(this.objectType, this.builder);
            ObjectBuilderValueResolver resolver = new ObjectBuilderValueResolver((ObjectBuilder)this.builder);
            return resolver.isDynamic() ? resolver : resolver.resolve(MuleExtensionUtils.getInitialiserEvent((MuleContext)this.muleContext));
        }, Exception.class, exception -> {
            throw exception;
        });
    }

    private void resolveParameterGroups(ObjectType objectType, DefaultObjectBuilder builder) {
        Class objectClass = JavaTypeUtils.getType((MetadataType)objectType);
        objectType.getFields().stream().filter(f -> f.getAnnotation(FlattenedTypeAnnotation.class).isPresent()).forEach(groupField -> {
            if (!(groupField.getValue() instanceof ObjectType)) {
                return;
            }
            ObjectType groupType = (ObjectType)groupField.getValue();
            Field objectField = this.getField(objectClass, this.getFieldKey((ObjectFieldType)groupField));
            DefaultObjectBuilder groupBuilder = new DefaultObjectBuilder(JavaTypeUtils.getType((MetadataType)groupField.getValue()));
            builder.addPropertyResolver(objectField.getName(), (ValueResolver)new ObjectBuilderValueResolver((ObjectBuilder)groupBuilder));
            this.resolveParameters(groupType, groupBuilder);
            this.resolveParameterGroups(groupType, groupBuilder);
        });
    }

    private void resolveParameters(ObjectType objectType, DefaultObjectBuilder builder) {
        Class objectClass = JavaTypeUtils.getType((MetadataType)objectType);
        boolean isParameterGroup = objectType.getAnnotation(FlattenedTypeAnnotation.class).isPresent();
        Map<String, Object> parameters = this.getParameters();
        objectType.getFields().forEach(field -> {
            String key = this.getFieldKey((ObjectFieldType)field);
            ValueResolver valueResolver = null;
            Field objectField = this.getField(objectClass, key);
            if (parameters.containsKey(key)) {
                valueResolver = this.toValueResolver(parameters.get(key));
            } else if (!isParameterGroup) {
                valueResolver = MetadataTypeUtils.getDefaultValue((MetadataType)field).map(value -> new TypeSafeExpressionValueResolver(value, objectField.getType(), this.muleContext)).orElse(null);
            }
            Optional nullSafe = field.getAnnotation(NullSafeTypeAnnotation.class);
            if (nullSafe.isPresent()) {
                ValueResolver delegate = valueResolver != null ? valueResolver : new StaticValueResolver(null);
                valueResolver = NullSafeValueResolverWrapper.of((ValueResolver)delegate, (MetadataType)((NullSafeTypeAnnotation)nullSafe.get()).getType(), (MuleContext)this.muleContext);
            }
            if (valueResolver != null) {
                builder.addPropertyResolver(objectField.getName(), valueResolver);
            }
        });
    }

    private Field getField(Class<?> objectClass, String key) {
        return (Field)IntrospectionUtils.getFieldByNameOrAlias(objectClass, (String)key).orElseThrow(() -> new IllegalModelDefinitionException(String.format("Class '%s' does not contain field %s", objectClass.getName(), key)));
    }

    private String getFieldKey(ObjectFieldType field) {
        return field.getKey().getName().getLocalPart();
    }
}

