/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl.parameter;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.DictionaryType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.internal.utils.MetadataTypeUtils;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.dsl.api.component.AttributeDefinition;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.TypeConverter;
import org.mule.runtime.dsl.api.component.TypeDefinition;
import org.mule.runtime.extension.api.declaration.type.TypeUtils;
import org.mule.runtime.extension.api.declaration.type.annotation.FlattenedTypeAnnotation;
import org.mule.runtime.extension.xml.dsl.api.DslElementSyntax;
import org.mule.runtime.extension.xml.dsl.api.resolver.DslSyntaxResolver;
import org.mule.runtime.module.extension.internal.config.dsl.ExtensionDefinitionParser;
import org.mule.runtime.module.extension.internal.config.dsl.ExtensionParsingContext;
import org.mule.runtime.module.extension.internal.config.dsl.parameter.TopLevelParameterObjectFactory;
import org.mule.runtime.module.extension.internal.introspection.describer.model.InfrastructureTypeMapping;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.util.ExtensionMetadataTypeUtils;

public class ObjectTypeParameterParser
extends ExtensionDefinitionParser {
    private final ObjectType type;
    private final ClassLoader classLoader;
    private final DslElementSyntax typeDsl;
    private final String name;
    private final String namespace;
    private final Map<String, String> infrastructureParameterMap = InfrastructureTypeMapping.getNameMap();

    public ObjectTypeParameterParser(ComponentBuildingDefinition.Builder definition, ObjectType type, ClassLoader classLoader, DslSyntaxResolver dslResolver, ExtensionParsingContext context, MuleContext muleContext) {
        super(definition, dslResolver, context, muleContext);
        this.type = type;
        this.classLoader = classLoader;
        this.typeDsl = (DslElementSyntax)dslResolver.resolve((MetadataType)type).orElseThrow(() -> new IllegalArgumentException("Non parseable object"));
        this.name = this.typeDsl.getElementName();
        this.namespace = this.typeDsl.getNamespace();
    }

    public ObjectTypeParameterParser(ComponentBuildingDefinition.Builder definition, String name, String namespace, ObjectType type, ClassLoader classLoader, DslSyntaxResolver dslResolver, ExtensionParsingContext context, MuleContext muleContext) {
        super(definition, dslResolver, context, muleContext);
        this.type = type;
        this.classLoader = classLoader;
        this.typeDsl = (DslElementSyntax)dslResolver.resolve((MetadataType)type).orElseThrow(() -> new IllegalArgumentException("Non parseable object"));
        this.name = name;
        this.namespace = namespace;
    }

    @Override
    protected void doParse(ComponentBuildingDefinition.Builder definitionBuilder) throws ConfigurationException {
        definitionBuilder.withIdentifier(this.name).withNamespace(this.namespace).asNamed().withTypeDefinition(TypeDefinition.fromType(ValueResolver.class)).withObjectFactoryType(TopLevelParameterObjectFactory.class).withConstructorParameterDefinition(AttributeDefinition.Builder.fromFixedValue((Object)this.type).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromFixedValue((Object)this.classLoader).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromFixedValue((Object)this.muleContext).build());
        this.type.getFields().forEach(this::parseField);
    }

    private Optional<String> getInfrastructureParameterName(MetadataType fieldType) {
        return Optional.ofNullable(this.infrastructureParameterMap.get(ExtensionMetadataTypeUtils.getId((MetadataType)fieldType)));
    }

    private void parseField(final ObjectFieldType objectField) {
        MetadataType fieldType = objectField.getValue();
        final String fieldName = objectField.getKey().getName().getLocalPart();
        final boolean acceptsReferences = TypeUtils.acceptsReferences((MetadataType)objectField);
        final Object defaultValue = MetadataTypeUtils.getDefaultValue((MetadataType)fieldType).orElse(null);
        final ExpressionSupport expressionSupport = TypeUtils.getExpressionSupport((MetadataType)objectField);
        final Optional fieldDsl = this.typeDsl.getChild(fieldName);
        if (!fieldDsl.isPresent() && !this.isParameterGroup(objectField)) {
            return;
        }
        Optional<String> keyName = this.getInfrastructureParameterName(fieldType);
        if (keyName.isPresent()) {
            this.parseObject(fieldName, keyName.get(), (ObjectType)fieldType, defaultValue, expressionSupport, false, acceptsReferences, (DslElementSyntax)fieldDsl.get(), Collections.emptySet());
            return;
        }
        final boolean isContent = TypeUtils.isContent((MetadataType)objectField);
        fieldType.accept(new MetadataTypeVisitor(){

            protected void defaultVisit(MetadataType metadataType) {
                ObjectTypeParameterParser.this.parseAttributeParameter(fieldName, fieldName, metadataType, defaultValue, expressionSupport, false, Collections.emptySet());
            }

            public void visitString(StringType stringType) {
                if (((DslElementSyntax)fieldDsl.get()).supportsChildDeclaration()) {
                    ObjectTypeParameterParser.this.addParameter(fieldName, AttributeDefinition.Builder.fromChildConfiguration(String.class).withWrapperIdentifier(fieldName));
                    ObjectTypeParameterParser.this.addDefinition(ObjectTypeParameterParser.this.baseDefinitionBuilder.copy().withIdentifier(fieldName).withTypeDefinition(TypeDefinition.fromType(String.class)).withTypeConverter(value -> ObjectTypeParameterParser.this.resolverOf(fieldName, (MetadataType)stringType, value, defaultValue, expressionSupport, false, Collections.emptySet(), acceptsReferences)).build());
                } else {
                    this.defaultVisit((MetadataType)stringType);
                }
            }

            public void visitObject(ObjectType objectType) {
                if (ObjectTypeParameterParser.this.isParameterGroup(objectField)) {
                    objectType.getFields().forEach(field -> ObjectTypeParameterParser.this.parseField(field));
                    return;
                }
                if (this.parseAsContent(isContent, (MetadataType)objectType)) {
                    return;
                }
                DslElementSyntax dsl = (DslElementSyntax)fieldDsl.get();
                if (!ObjectTypeParameterParser.this.parsingContext.isRegistered(dsl.getElementName(), dsl.getNamespace())) {
                    ObjectTypeParameterParser.this.parsingContext.registerObjectType(dsl.getElementName(), dsl.getNamespace(), ObjectTypeParameterParser.this.type);
                    ObjectTypeParameterParser.this.parseObjectParameter(fieldName, fieldName, objectType, defaultValue, expressionSupport, false, acceptsReferences, dsl, Collections.emptySet());
                } else {
                    ObjectTypeParameterParser.this.parseObject(fieldName, fieldName, objectType, defaultValue, expressionSupport, false, acceptsReferences, dsl, Collections.emptySet());
                }
            }

            public void visitArrayType(ArrayType arrayType) {
                if (!this.parseAsContent(isContent, (MetadataType)arrayType)) {
                    ObjectTypeParameterParser.this.parseCollectionParameter(fieldName, fieldName, arrayType, defaultValue, expressionSupport, false, (DslElementSyntax)fieldDsl.get(), Collections.emptySet());
                }
            }

            public void visitDictionary(DictionaryType dictionaryType) {
                if (!this.parseAsContent(isContent, (MetadataType)dictionaryType)) {
                    ObjectTypeParameterParser.this.parseMapParameters(fieldName, fieldName, dictionaryType, defaultValue, expressionSupport, false, (DslElementSyntax)fieldDsl.get(), Collections.emptySet());
                }
            }

            private boolean parseAsContent(boolean isContent2, MetadataType type) {
                if (isContent2) {
                    ObjectTypeParameterParser.this.parseFromTextExpression(fieldName, (DslElementSyntax)fieldDsl.get(), (Supplier<TypeConverter>)() -> value -> ObjectTypeParameterParser.this.resolverOf(fieldName, type, value, defaultValue, expressionSupport, false, Collections.emptySet(), false));
                    return true;
                }
                return false;
            }
        });
    }

    private boolean isParameterGroup(ObjectFieldType type) {
        return type.getAnnotation(FlattenedTypeAnnotation.class).isPresent();
    }
}

