/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.schema.builder;

import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.extension.xml.dsl.api.DslElementSyntax;
import org.mule.runtime.module.extension.internal.capability.xml.schema.builder.ExecutableTypeSchemaDelegate;
import org.mule.runtime.module.extension.internal.capability.xml.schema.builder.SchemaBuilder;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ExplicitGroup;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ExtensionType;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.TopLevelElement;
import org.mule.runtime.module.extension.internal.xml.SchemaConstants;

class SourceSchemaDelegate
extends ExecutableTypeSchemaDelegate {
    SourceSchemaDelegate(SchemaBuilder builder) {
        super(builder);
    }

    void registerMessageSource(SourceModel sourceModel, DslElementSyntax dslSyntax) {
        String typeName = StringUtils.capitalize((String)sourceModel.getName()) + "Type";
        this.registerSourceElement(sourceModel, typeName, dslSyntax);
        this.registerSourceType(typeName, sourceModel, dslSyntax);
    }

    private void registerSourceElement(SourceModel sourceModel, String typeName, DslElementSyntax dslSyntax) {
        TopLevelElement element = new TopLevelElement();
        element.setName(dslSyntax.getElementName());
        element.setType(new QName(this.builder.getSchema().getTargetNamespace(), typeName));
        element.setAnnotation(this.builder.createDocAnnotation(sourceModel.getDescription()));
        element.setSubstitutionGroup(SchemaConstants.MULE_ABSTRACT_MESSAGE_SOURCE);
        this.builder.getSchema().getSimpleTypeOrComplexTypeOrGroup().add(element);
    }

    private void registerSourceType(String name, SourceModel sourceModel, DslElementSyntax dslSyntax) {
        ExtensionType extensionType = this.registerExecutableType(name, (ParameterizedModel)sourceModel, SchemaConstants.MULE_ABSTRACT_MESSAGE_SOURCE_TYPE, dslSyntax);
        ExplicitGroup sequence = extensionType.getSequence();
        if (sequence == null) {
            sequence = new ExplicitGroup();
            extensionType.setSequence(sequence);
        }
        this.builder.addRetryPolicy(sequence);
        this.addMessageRedeliveryPolicy(sequence);
    }

    private void addMessageRedeliveryPolicy(ExplicitGroup sequence) {
        TopLevelElement redeliveryPolicy = this.builder.createRefElement(SchemaConstants.MULE_ABSTRACT_REDELIVERY_POLICY, false);
        sequence.getParticle().add(this.objectFactory.createElement(redeliveryPolicy));
    }
}

