/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.schema;

import java.util.Collection;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.core.util.CollectionUtils;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.module.extension.internal.capability.xml.schema.AnnotationProcessorUtils;
import org.mule.runtime.module.extension.internal.capability.xml.schema.MethodDocumentation;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

final class SchemaDocumenter {
    private ProcessingEnvironment processingEnv;

    SchemaDocumenter(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    void document(ExtensionDeclaration extensionDeclaration, TypeElement extensionElement, RoundEnvironment roundEnvironment) {
        extensionDeclaration.setDescription(AnnotationProcessorUtils.getJavaDocSummary(this.processingEnv, extensionElement));
        this.documentConfigurations(extensionDeclaration, extensionElement, roundEnvironment);
        this.documentOperations(roundEnvironment, this.processingEnv, extensionDeclaration);
    }

    private void documentOperations(RoundEnvironment roundEnv, ProcessingEnvironment processingEnv, ExtensionDeclaration extensionDeclaration) {
        Map<String, Element> methods = AnnotationProcessorUtils.getOperationMethods(roundEnv, processingEnv);
        try {
            for (OperationDeclaration operation : extensionDeclaration.getOperations()) {
                Element method = methods.get(operation.getName());
                if (method == null) continue;
                MethodDocumentation documentation = AnnotationProcessorUtils.getMethodDocumentation(processingEnv, method);
                operation.setDescription(documentation.getSummary());
                this.documentOperationParameters(operation, documentation);
            }
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Exception found while trying to document XSD schema"), (Throwable)e);
        }
    }

    private void documentOperationParameters(OperationDeclaration operation, MethodDocumentation documentation) {
        for (ParameterDeclaration parameter : operation.getAllParameters()) {
            String description = documentation.getParameters().get(parameter.getName());
            if (description == null) continue;
            parameter.setDescription(description);
        }
    }

    private void documentConfigurations(ExtensionDeclaration extensionDeclaration, TypeElement extensionElement, RoundEnvironment roundEnvironment) {
        if (extensionDeclaration.getConfigurations().size() > 1) {
            for (TypeElement configurationElement : AnnotationProcessorUtils.getTypeElementsAnnotatedWith(Configuration.class, roundEnvironment)) {
                ConfigurationDeclaration configurationDeclaration = this.findMatchingConfiguration(extensionDeclaration, configurationElement);
                this.documentConfigurationParameters(configurationDeclaration.getAllParameters(), configurationElement);
            }
        } else {
            this.documentConfigurationParameters(((ConfigurationDeclaration)extensionDeclaration.getConfigurations().get(0)).getAllParameters(), extensionElement);
        }
    }

    private void documentConfigurationParameters(Collection<ParameterDeclaration> parameters, TypeElement element) {
        Map<String, VariableElement> variableElements = AnnotationProcessorUtils.getFieldsAnnotatedWith(element, Parameter.class);
        TypeElement traversingElement = element;
        while (traversingElement != null && !Object.class.getName().equals(traversingElement.getQualifiedName().toString())) {
            Class declaringClass = AnnotationProcessorUtils.classFor(traversingElement, this.processingEnv);
            for (ParameterDeclaration parameter : parameters) {
                IntrospectionUtils.getField(declaringClass, (ParameterDeclaration)parameter).filter(field -> variableElements.containsKey(field.getName())).ifPresent(field -> parameter.setDescription(AnnotationProcessorUtils.getJavaDocSummary(this.processingEnv, (Element)variableElements.get(field.getName()))));
            }
            traversingElement = (TypeElement)this.processingEnv.getTypeUtils().asElement(traversingElement.getSuperclass());
        }
        for (VariableElement variableElement : AnnotationProcessorUtils.getFieldsAnnotatedWith(element, ParameterGroup.class).values()) {
            TypeElement typeElement = (TypeElement)this.processingEnv.getTypeUtils().asElement(variableElement.asType());
            this.documentConfigurationParameters(parameters, typeElement);
        }
    }

    private ConfigurationDeclaration findMatchingConfiguration(ExtensionDeclaration extensionDeclaration, TypeElement configurationElement) {
        return (ConfigurationDeclaration)CollectionUtils.find((Collection)extensionDeclaration.getConfigurations(), object -> {
            Configuration configuration = configurationElement.getAnnotation(Configuration.class);
            ConfigurationDeclaration configurationDeclaration = (ConfigurationDeclaration)object;
            return configurationDeclaration.getName().equals(configuration.name());
        });
    }
}

