/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.config;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.spring.factories.MessageProcessorChainFactoryBean;
import org.mule.config.spring.factories.PollingMessageSourceFactoryBean;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.enricher.MessageEnricher;
import org.mule.extension.introspection.DataQualifier;
import org.mule.extension.introspection.DataQualifierVisitor;
import org.mule.extension.introspection.DataType;
import org.mule.extension.introspection.Operation;
import org.mule.extension.introspection.Parameter;
import org.mule.module.extension.internal.config.OperationFactoryBean;
import org.mule.module.extension.internal.config.XmlExtensionParserUtils;
import org.mule.module.extension.internal.introspection.BaseDataQualifierVisitor;
import org.mule.module.extension.internal.util.NameUtils;
import org.mule.util.ArrayUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

final class OperationBeanDefinitionParser
implements BeanDefinitionParser {
    private final Operation operation;

    OperationBeanDefinitionParser(Operation operation) {
        this.operation = operation;
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(OperationFactoryBean.class);
        builder.setScope("prototype");
        this.parseConfigRef(element, builder);
        builder.addConstructorArgValue((Object)this.operation);
        builder.addConstructorArgValue((Object)XmlExtensionParserUtils.toElementDescriptorBeanDefinition(element));
        builder.addConstructorArgValue(this.parseNestedOperations(element, parserContext));
        builder.addConstructorArgReference("_muleContext");
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        XmlExtensionParserUtils.setNoRecurseOnDefinition((BeanDefinition)definition);
        this.attachProcessorDefinition(parserContext, (BeanDefinition)definition);
        return definition;
    }

    private ManagedMap<String, ManagedList<MessageProcessor>> parseNestedOperations(final Element element, final ParserContext parserContext) {
        final ManagedMap nestedOperations = new ManagedMap();
        for (final Parameter parameter : this.operation.getParameters()) {
            final DataType type = parameter.getType();
            type.getQualifier().accept((DataQualifierVisitor)new BaseDataQualifierVisitor(){

                public void onOperation() {
                    nestedOperations.put((Object)parameter.getName(), (Object)OperationBeanDefinitionParser.this.parseNestedProcessor(element, parameter, parserContext));
                }

                public void onList() {
                    Object[] generics = type.getGenericTypes();
                    if (!ArrayUtils.isEmpty((Object[])generics) && generics[0].getQualifier() == DataQualifier.OPERATION) {
                        nestedOperations.put((Object)parameter.getName(), (Object)OperationBeanDefinitionParser.this.parseNestedProcessor(element, parameter, parserContext));
                    }
                }
            });
        }
        return nestedOperations;
    }

    private void parseConfigRef(Element element, BeanDefinitionBuilder builder) {
        String configRef = element.getAttribute("config-ref");
        if (StringUtils.isBlank((String)configRef)) {
            configRef = null;
        }
        builder.addConstructorArgValue((Object)configRef);
    }

    private String generateChildBeanName(Element element) {
        String id = SpringXMLUtils.getNameOrId((Element)element);
        if (StringUtils.isBlank((String)id)) {
            String parentId = SpringXMLUtils.getNameOrId((Element)((Element)element.getParentNode()));
            return String.format(".%s:%s", parentId, element.getLocalName());
        }
        return id;
    }

    private ManagedList<MessageProcessor> parseNestedProcessor(Element element, Parameter parameter, ParserContext parserContext) {
        element = DomUtils.getChildElementByTagName((Element)element, (String)NameUtils.hyphenize((String)parameter.getName()));
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(MessageProcessorChainFactoryBean.class);
        AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
        String childBeanName = this.generateChildBeanName(element);
        parserContext.getRegistry().registerBeanDefinition(childBeanName, (BeanDefinition)beanDefinition);
        element.setAttribute("name", childBeanName);
        builder.getRawBeanDefinition().setSource(parserContext.extractSource((Object)element));
        builder.setScope("singleton");
        ManagedList processors = (ManagedList)parserContext.getDelegate().parseListElement(element, (BeanDefinition)builder.getBeanDefinition());
        parserContext.getRegistry().removeBeanDefinition(this.generateChildBeanName(element));
        return processors;
    }

    private void attachProcessorDefinition(ParserContext parserContext, BeanDefinition definition) {
        MutablePropertyValues propertyValues = parserContext.getContainingBeanDefinition().getPropertyValues();
        if (parserContext.getContainingBeanDefinition().getBeanClassName().equals(PollingMessageSourceFactoryBean.class.getName())) {
            propertyValues.addPropertyValue("messageProcessor", (Object)definition);
        } else if (parserContext.getContainingBeanDefinition().getBeanClassName().equals(MessageEnricher.class.getName())) {
            propertyValues.addPropertyValue("enrichmentMessageProcessor", (Object)definition);
        } else {
            PropertyValue messageProcessors = propertyValues.getPropertyValue("messageProcessors");
            if (messageProcessors == null || messageProcessors.getValue() == null) {
                propertyValues.addPropertyValue("messageProcessors", (Object)new ManagedList());
            }
            List listMessageProcessors = (List)propertyValues.getPropertyValue("messageProcessors").getValue();
            listMessageProcessors.add(definition);
        }
    }

    private void attachSourceDefinition(ParserContext parserContext, BeanDefinition definition) {
        MutablePropertyValues propertyValues = parserContext.getContainingBeanDefinition().getPropertyValues();
        propertyValues.addPropertyValue("messageSource", (Object)definition);
    }
}

