/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.config;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.mule.util.CollectionUtils;

public final class ElementDescriptor {
    private final String name;
    private final Map<String, String> attributes;
    private final Multimap<String, ElementDescriptor> childs;

    public ElementDescriptor(String name, Map<String, String> attributes, List<ElementDescriptor> childs) {
        this.name = name;
        this.attributes = attributes;
        this.childs = ArrayListMultimap.create();
        for (ElementDescriptor child : childs) {
            this.childs.put((Object)child.getName(), (Object)child);
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean hasAttribute(String attributeName) {
        return !StringUtils.isBlank((String)this.getAttribute(attributeName));
    }

    public String getAttribute(String attributeName) {
        return this.attributes.get(attributeName);
    }

    public Collection<ElementDescriptor> getChilds() {
        return this.childs.values();
    }

    public ElementDescriptor getChildByName(String childName) {
        Collection values = this.childs.get((Object)childName);
        return CollectionUtils.isEmpty((Collection)values) ? null : (ElementDescriptor)values.iterator().next();
    }

    public Collection<ElementDescriptor> getChildsByName(String childName) {
        return this.childs.get((Object)childName);
    }
}

