/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.capability.xml.schema;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.commons.collections.CollectionUtils;
import org.mule.extension.annotations.Extensible;
import org.mule.extension.introspection.Capable;
import org.mule.extension.introspection.Configuration;
import org.mule.extension.introspection.DataQualifier;
import org.mule.extension.introspection.DataQualifierVisitor;
import org.mule.extension.introspection.DataType;
import org.mule.extension.introspection.Operation;
import org.mule.extension.introspection.Parameter;
import org.mule.module.extension.internal.capability.metadata.HiddenCapability;
import org.mule.module.extension.internal.capability.metadata.ImplementedTypeCapability;
import org.mule.module.extension.internal.capability.metadata.TypeRestrictionCapability;
import org.mule.module.extension.internal.capability.xml.schema.model.Annotation;
import org.mule.module.extension.internal.capability.xml.schema.model.Attribute;
import org.mule.module.extension.internal.capability.xml.schema.model.ComplexContent;
import org.mule.module.extension.internal.capability.xml.schema.model.ComplexType;
import org.mule.module.extension.internal.capability.xml.schema.model.Documentation;
import org.mule.module.extension.internal.capability.xml.schema.model.ExplicitGroup;
import org.mule.module.extension.internal.capability.xml.schema.model.ExtensionType;
import org.mule.module.extension.internal.capability.xml.schema.model.FormChoice;
import org.mule.module.extension.internal.capability.xml.schema.model.GroupRef;
import org.mule.module.extension.internal.capability.xml.schema.model.Import;
import org.mule.module.extension.internal.capability.xml.schema.model.LocalComplexType;
import org.mule.module.extension.internal.capability.xml.schema.model.LocalSimpleType;
import org.mule.module.extension.internal.capability.xml.schema.model.NamedGroup;
import org.mule.module.extension.internal.capability.xml.schema.model.NoFixedFacet;
import org.mule.module.extension.internal.capability.xml.schema.model.ObjectFactory;
import org.mule.module.extension.internal.capability.xml.schema.model.Restriction;
import org.mule.module.extension.internal.capability.xml.schema.model.Schema;
import org.mule.module.extension.internal.capability.xml.schema.model.SchemaConstants;
import org.mule.module.extension.internal.capability.xml.schema.model.SchemaTypeConversion;
import org.mule.module.extension.internal.capability.xml.schema.model.SimpleContent;
import org.mule.module.extension.internal.capability.xml.schema.model.SimpleExtensionType;
import org.mule.module.extension.internal.capability.xml.schema.model.TopLevelComplexType;
import org.mule.module.extension.internal.capability.xml.schema.model.TopLevelElement;
import org.mule.module.extension.internal.capability.xml.schema.model.TopLevelSimpleType;
import org.mule.module.extension.internal.capability.xml.schema.model.Union;
import org.mule.module.extension.internal.introspection.BaseDataQualifierVisitor;
import org.mule.module.extension.internal.util.CapabilityUtils;
import org.mule.module.extension.internal.util.IntrospectionUtils;
import org.mule.module.extension.internal.util.NameUtils;
import org.mule.util.ArrayUtils;
import org.mule.util.Preconditions;
import org.mule.util.StringUtils;

public class SchemaBuilder {
    private Set<DataType> registeredEnums;
    private Map<DataType, ComplexTypeHolder> registeredComplexTypesHolders;
    private Map<String, NamedGroup> substitutionGroups = new HashMap<String, NamedGroup>();
    private Schema schema;
    private ObjectFactory objectFactory;

    private SchemaBuilder() {
        this.registeredEnums = new HashSet<DataType>();
        this.objectFactory = new ObjectFactory();
        this.registeredComplexTypesHolders = new HashMap<DataType, ComplexTypeHolder>();
    }

    public static SchemaBuilder newSchema(String targetNamespace) {
        SchemaBuilder builder = new SchemaBuilder();
        builder.schema = new Schema();
        builder.schema.setTargetNamespace(targetNamespace);
        builder.schema.setElementFormDefault(FormChoice.QUALIFIED);
        builder.schema.setAttributeFormDefault(FormChoice.UNQUALIFIED);
        builder.importXmlNamespace().importSpringFrameworkNamespace().importMuleNamespace();
        return builder;
    }

    public Schema getSchema() {
        return this.schema;
    }

    private SchemaBuilder importXmlNamespace() {
        Import xmlImport = new Import();
        xmlImport.setNamespace("http://www.w3.org/XML/1998/namespace");
        this.schema.getIncludeOrImportOrRedefine().add(xmlImport);
        return this;
    }

    private SchemaBuilder importSpringFrameworkNamespace() {
        Import springFrameworkImport = new Import();
        springFrameworkImport.setNamespace("http://www.springframework.org/schema/beans");
        springFrameworkImport.setSchemaLocation("http://www.springframework.org/schema/beans/spring-beans-3.0.xsd");
        this.schema.getIncludeOrImportOrRedefine().add(springFrameworkImport);
        return this;
    }

    private SchemaBuilder importMuleNamespace() {
        Import muleSchemaImport = new Import();
        muleSchemaImport.setNamespace("http://www.mulesoft.org/schema/mule/core");
        muleSchemaImport.setSchemaLocation("http://www.mulesoft.org/schema/mule/core/current/mule.xsd");
        this.schema.getIncludeOrImportOrRedefine().add(muleSchemaImport);
        return this;
    }

    public SchemaBuilder registerConfigElement(Configuration configuration) {
        HashMap<QName, String> otherAttributes = new HashMap<QName, String>();
        final ExtensionType config = this.registerExtension(configuration.getName(), otherAttributes);
        config.getAttributeOrAttributeGroup().add(this.createNameAttribute());
        final ExplicitGroup choice = new ExplicitGroup();
        choice.setMinOccurs(new BigInteger("0"));
        choice.setMaxOccurs("unbounded");
        config.setChoice(choice);
        for (final Parameter parameter : configuration.getParameters()) {
            parameter.getType().getQualifier().accept((DataQualifierVisitor)new BaseDataQualifierVisitor(){
                private boolean forceOptional = false;

                public void onList() {
                    this.forceOptional = true;
                    this.defaultOperation();
                    SchemaBuilder.this.generateCollectionElement(choice, parameter, true);
                }

                public void onPojo() {
                    this.forceOptional = false;
                    this.defaultOperation();
                    SchemaBuilder.this.registerComplexTypeChildElement(choice, parameter.getName(), parameter.getDescription(), parameter.getType(), IntrospectionUtils.isRequired((Parameter)parameter, (boolean)this.forceOptional));
                }

                protected void defaultOperation() {
                    config.getAttributeOrAttributeGroup().add(SchemaBuilder.this.createAttribute(parameter, IntrospectionUtils.isRequired((Parameter)parameter, (boolean)this.forceOptional)));
                }
            });
        }
        config.setAnnotation(this.createDocAnnotation(configuration.getDescription()));
        if (choice.getParticle().size() == 0) {
            config.setChoice(null);
        }
        return this;
    }

    private Attribute createNameAttribute() {
        return this.createAttribute("name", DataType.of(String.class), true, false);
    }

    public SchemaBuilder registerOperation(Operation operation) {
        String typeName = StringUtils.capitalize((String)operation.getName()) + "Type";
        this.registerProcessorElement(operation, typeName);
        this.registerOperationType(typeName, operation);
        return this;
    }

    private String registerPojoType(DataType type, String description) {
        ComplexTypeHolder alreadyRegisteredType = this.registeredComplexTypesHolders.get(type);
        if (alreadyRegisteredType != null) {
            return alreadyRegisteredType.getComplexType().getName();
        }
        this.registerBasePojoType(type, description);
        this.registerPojoGlobalElement(type, description);
        return this.getBaseTypeName(type);
    }

    private String getBaseTypeName(DataType type) {
        return type.getName();
    }

    private TopLevelComplexType registerBasePojoType(DataType type, String description) {
        TopLevelComplexType complexType = new TopLevelComplexType();
        this.registeredComplexTypesHolders.put(type, new ComplexTypeHolder(complexType, type));
        complexType.setName(type.getName());
        complexType.setAnnotation(this.createDocAnnotation(description));
        ComplexContent complexContent = new ComplexContent();
        complexType.setComplexContent(complexContent);
        final ExtensionType extension = new ExtensionType();
        extension.setBase(SchemaConstants.MULE_ABSTRACT_EXTENSION_TYPE);
        complexContent.setExtension(extension);
        final ExplicitGroup all = new ExplicitGroup();
        extension.setSequence(all);
        for (Field field : IntrospectionUtils.getParameterFields((Class)type.getRawType())) {
            if (IntrospectionUtils.isIgnored((AccessibleObject)field)) continue;
            final String name = IntrospectionUtils.getAlias((Field)field);
            final DataType fieldType = IntrospectionUtils.getFieldDataType((Field)field);
            final boolean required = IntrospectionUtils.isRequired((AccessibleObject)field);
            final boolean dynamic = IntrospectionUtils.isDynamic((AccessibleObject)field);
            fieldType.getQualifier().accept((DataQualifierVisitor)new BaseDataQualifierVisitor(){

                public void onList() {
                    SchemaBuilder.this.generateCollectionElement(all, name, "", fieldType, required);
                }

                public void onPojo() {
                    SchemaBuilder.this.registerComplexTypeChildElement(all, name, "", fieldType, false);
                }

                protected void defaultOperation() {
                    Attribute attribute = SchemaBuilder.this.createAttribute(name, fieldType, required, dynamic);
                    extension.getAttributeOrAttributeGroup().add(attribute);
                }
            });
        }
        this.schema.getSimpleTypeOrComplexTypeOrGroup().add(complexType);
        return complexType;
    }

    public SchemaBuilder registerEnums() {
        for (DataType enumToBeRegistered : this.registeredEnums) {
            this.registerEnum(this.schema, enumToBeRegistered);
        }
        return this;
    }

    private void registerEnum(Schema schema, DataType enumType) {
        TopLevelSimpleType enumSimpleType = new TopLevelSimpleType();
        enumSimpleType.setName(enumType.getName() + "EnumType");
        Union union = new Union();
        union.getSimpleType().add(this.createEnumSimpleType(enumType));
        union.getSimpleType().add(this.createExpressionAndPropertyPlaceHolderSimpleType());
        enumSimpleType.setUnion(union);
        schema.getSimpleTypeOrComplexTypeOrGroup().add(enumSimpleType);
    }

    private LocalSimpleType createExpressionAndPropertyPlaceHolderSimpleType() {
        LocalSimpleType expression = new LocalSimpleType();
        Restriction restriction = new Restriction();
        expression.setRestriction(restriction);
        restriction.setBase(SchemaConstants.MULE_PROPERTY_PLACEHOLDER_TYPE);
        return expression;
    }

    private LocalSimpleType createEnumSimpleType(DataType enumType) {
        LocalSimpleType enumValues = new LocalSimpleType();
        Restriction restriction = new Restriction();
        enumValues.setRestriction(restriction);
        restriction.setBase(SchemaConstants.STRING);
        Class enumClass = enumType.getRawType();
        for (Enum value : (Enum[])enumClass.getEnumConstants()) {
            NoFixedFacet noFixedFacet = this.objectFactory.createNoFixedFacet();
            noFixedFacet.setValue(value.name());
            JAXBElement<NoFixedFacet> enumeration = this.objectFactory.createEnumeration(noFixedFacet);
            enumValues.getRestriction().getFacets().add(enumeration);
        }
        return enumValues;
    }

    private void registerComplexTypeChildElement(ExplicitGroup all, String name, String description, DataType type, boolean required) {
        name = NameUtils.hyphenize((String)name);
        TopLevelElement objectElement = new TopLevelElement();
        objectElement.setName(name);
        objectElement.setMinOccurs(required ? BigInteger.ONE : BigInteger.ZERO);
        objectElement.setMaxOccurs("1");
        objectElement.setComplexType(this.newLocalComplexTypeWithBase(type, description));
        objectElement.setAnnotation(this.createDocAnnotation(description));
        all.getParticle().add(this.objectFactory.createElement(objectElement));
    }

    private void registerPojoGlobalElement(DataType type, String description) {
        TopLevelElement objectElement = new TopLevelElement();
        objectElement.setName(NameUtils.getGlobalPojoTypeName((DataType)type));
        LocalComplexType complexContent = this.newLocalComplexTypeWithBase(type, description);
        complexContent.getComplexContent().getExtension().getAttributeOrAttributeGroup().add(this.createNameAttribute());
        objectElement.setComplexType(complexContent);
        objectElement.setSubstitutionGroup(SchemaConstants.MULE_ABSTRACT_EXTENSION);
        objectElement.setAnnotation(this.createDocAnnotation(description));
        this.schema.getSimpleTypeOrComplexTypeOrGroup().add(objectElement);
    }

    private LocalComplexType newLocalComplexTypeWithBase(DataType type, String description) {
        LocalComplexType objectComplexType = new LocalComplexType();
        objectComplexType.setComplexContent(new ComplexContent());
        objectComplexType.getComplexContent().setExtension(new ExtensionType());
        objectComplexType.getComplexContent().getExtension().setBase(new QName(this.schema.getTargetNamespace(), this.registerPojoType(type, description)));
        return objectComplexType;
    }

    private ExtensionType registerExtension(String name, Map<QName, String> otherAttributes) {
        LocalComplexType complexType = new LocalComplexType();
        TopLevelElement extension = new TopLevelElement();
        extension.setName(name);
        extension.setSubstitutionGroup(SchemaConstants.MULE_ABSTRACT_EXTENSION);
        extension.setComplexType(complexType);
        extension.getOtherAttributes().putAll(otherAttributes);
        ComplexContent complexContent = new ComplexContent();
        complexType.setComplexContent(complexContent);
        ExtensionType complexContentExtension = new ExtensionType();
        complexContentExtension.setBase(SchemaConstants.MULE_ABSTRACT_EXTENSION_TYPE);
        complexContent.setExtension(complexContentExtension);
        this.schema.getSimpleTypeOrComplexTypeOrGroup().add(extension);
        return complexContentExtension;
    }

    private Attribute createAttribute(Parameter parameter, boolean required) {
        return this.createAttribute(parameter.getName(), parameter.getDescription(), parameter.getType(), required, parameter.isDynamic());
    }

    private Attribute createAttribute(String name, DataType type, boolean required, boolean dynamic) {
        return this.createAttribute(name, "", type, required, dynamic);
    }

    private Attribute createAttribute(final String name, String description, final DataType type, boolean required, final boolean dynamic) {
        final Attribute attribute = new Attribute();
        attribute.setUse(required ? "required" : "optional");
        attribute.setAnnotation(this.createDocAnnotation(description));
        type.getQualifier().accept((DataQualifierVisitor)new BaseDataQualifierVisitor(){

            public void onEnum() {
                attribute.setName(name);
                attribute.setType(new QName(SchemaBuilder.this.schema.getTargetNamespace(), type.getName() + "EnumType"));
                SchemaBuilder.this.registeredEnums.add(type);
            }

            protected void defaultOperation() {
                attribute.setName(name);
                attribute.setType(SchemaTypeConversion.convertType(type, dynamic));
            }
        });
        return attribute;
    }

    private void generateCollectionElement(ExplicitGroup all, Parameter parameter, boolean forceOptional) {
        boolean required = IntrospectionUtils.isRequired((Parameter)parameter, (boolean)forceOptional);
        this.generateCollectionElement(all, parameter.getName(), parameter.getDescription(), parameter.getType(), required);
    }

    private void generateCollectionElement(ExplicitGroup all, String name, String description, DataType type, boolean required) {
        name = NameUtils.hyphenize((String)name);
        BigInteger minOccurs = required ? BigInteger.ONE : BigInteger.ZERO;
        String collectionName = NameUtils.hyphenize((String)NameUtils.singularize((String)name));
        LocalComplexType collectionComplexType = this.generateCollectionComplexType(collectionName, description, type);
        TopLevelElement collectionElement = new TopLevelElement();
        collectionElement.setName(name);
        collectionElement.setMinOccurs(minOccurs);
        collectionElement.setMaxOccurs("1");
        collectionElement.setAnnotation(this.createDocAnnotation(description));
        all.getParticle().add(this.objectFactory.createElement(collectionElement));
        collectionElement.setComplexType(collectionComplexType);
    }

    private LocalComplexType generateCollectionComplexType(String name, final String description, DataType type) {
        LocalComplexType collectionComplexType = new LocalComplexType();
        ExplicitGroup sequence = new ExplicitGroup();
        collectionComplexType.setSequence(sequence);
        final TopLevelElement collectionItemElement = new TopLevelElement();
        collectionItemElement.setName(name);
        collectionItemElement.setMinOccurs(BigInteger.ZERO);
        collectionItemElement.setMaxOccurs("unbounded");
        final DataType genericType = this.getGenericType(type);
        genericType.getQualifier().accept((DataQualifierVisitor)new BaseDataQualifierVisitor(){

            public void onPojo() {
                collectionItemElement.setComplexType(SchemaBuilder.this.newLocalComplexTypeWithBase(genericType, description));
            }

            protected void defaultOperation() {
                collectionItemElement.setComplexType(SchemaBuilder.this.generateComplexValueType(genericType));
            }
        });
        sequence.getParticle().add(this.objectFactory.createElement(collectionItemElement));
        return collectionComplexType;
    }

    private LocalComplexType generateComplexValueType(DataType type) {
        LocalComplexType complexType = new LocalComplexType();
        SimpleContent simpleContent = new SimpleContent();
        complexType.setSimpleContent(simpleContent);
        SimpleExtensionType simpleContentExtension = new SimpleExtensionType();
        QName extensionBase = SchemaTypeConversion.convertType(type, false);
        simpleContentExtension.setBase(extensionBase);
        simpleContent.setExtension(simpleContentExtension);
        Attribute valueAttribute = this.createAttribute("value", type, true, true);
        simpleContentExtension.getAttributeOrAttributeGroup().add(valueAttribute);
        return complexType;
    }

    private DataType getGenericType(DataType type) {
        return ArrayUtils.isEmpty((Object[])type.getGenericTypes()) ? type : type.getGenericTypes()[0];
    }

    private void registerProcessorElement(Operation operation, String typeName) {
        TopLevelElement element = new TopLevelElement();
        element.setName(this.getOperationName(operation));
        element.setType(new QName(this.schema.getTargetNamespace(), typeName));
        element.setAnnotation(this.createDocAnnotation(operation.getDescription()));
        element.setSubstitutionGroup(this.getOperationSubstitutionGroup(operation));
        this.schema.getSimpleTypeOrComplexTypeOrGroup().add(element);
    }

    private QName getOperationSubstitutionGroup(Operation operation) {
        QName substitutionGroup = SchemaConstants.MULE_ABSTRACT_MESSAGE_PROCESSOR;
        ImplementedTypeCapability implementation = (ImplementedTypeCapability)CapabilityUtils.getSingleCapability((Capable)operation, ImplementedTypeCapability.class);
        if (implementation != null) {
            substitutionGroup = this.getSubstitutionGroup(operation, implementation.getType());
        }
        return substitutionGroup;
    }

    private QName getSubstitutionGroup(Operation operation, Class<?> type) {
        return new QName(this.schema.getTargetNamespace(), this.registerExtensibleElement(operation, type));
    }

    private String registerExtensibleElement(Operation operation, Class<?> type) {
        NamedGroup group;
        Extensible extensible = type.getAnnotation(Extensible.class);
        Preconditions.checkArgument((extensible != null ? 1 : 0) != 0, (String)String.format("Type %s is not extensible", type.getName()));
        String name = extensible.alias();
        if (StringUtils.isBlank((String)name)) {
            name = type.getName() + "-OperationGroup";
        }
        if ((group = this.substitutionGroups.get(name)) == null) {
            TopLevelElement element = new TopLevelElement();
            element.setName(name);
            element.setAbstract(true);
            element.setSubstitutionGroup(SchemaConstants.MULE_ABSTRACT_MESSAGE_PROCESSOR);
            this.schema.getSimpleTypeOrComplexTypeOrGroup().add(element);
            group = new NamedGroup();
            group.setName(this.getGroupName(name));
            this.schema.getSimpleTypeOrComplexTypeOrGroup().add(group);
            this.substitutionGroups.put(name, group);
            element = new TopLevelElement();
            element.setRef(new QName(this.schema.getTargetNamespace(), name));
            group.getChoice().getParticle().add(this.objectFactory.createElement(element));
        }
        return name;
    }

    private String getOperationName(Operation operation) {
        return NameUtils.hyphenize((String)operation.getName());
    }

    private String getGroupName(String name) {
        return name + "-group";
    }

    private void registerOperationType(String name, Operation operation) {
        QName base = SchemaConstants.MULE_ABSTRACT_MESSAGE_PROCESSOR_TYPE;
        TopLevelComplexType complexType = new TopLevelComplexType();
        complexType.setName(name);
        ComplexContent complexContent = new ComplexContent();
        complexType.setComplexContent(complexContent);
        final ExtensionType complexContentExtension = new ExtensionType();
        complexContentExtension.setBase(base);
        complexContent.setExtension(complexContentExtension);
        Attribute configAttr = this.createAttribute("config-ref", "Specify which configuration to use for this invocation.", true, SchemaConstants.SUBSTITUTABLE_NAME);
        complexContentExtension.getAttributeOrAttributeGroup().add(configAttr);
        final ExplicitGroup all = new ExplicitGroup();
        complexContentExtension.setSequence(all);
        for (final Parameter parameter : operation.getParameters()) {
            if (this.isHidden(parameter)) continue;
            DataType parameterType = parameter.getType();
            DataQualifier parameterQualifier = parameterType.getQualifier();
            if (this.isOperation(parameterType)) {
                String maxOccurs = parameterQualifier == DataQualifier.LIST ? "unbounded" : "1";
                this.generateNestedProcessorElement(all, operation, parameter, maxOccurs);
                continue;
            }
            parameterQualifier.accept((DataQualifierVisitor)new BaseDataQualifierVisitor(){

                public void onList() {
                    SchemaBuilder.this.generateCollectionElement(all, parameter, false);
                }

                protected void defaultOperation() {
                    complexContentExtension.getAttributeOrAttributeGroup().add(SchemaBuilder.this.createAttribute(parameter, parameter.isRequired()));
                }
            });
        }
        if (all.getParticle().size() == 0) {
            complexContentExtension.setSequence(null);
        }
        this.schema.getSimpleTypeOrComplexTypeOrGroup().add(complexType);
    }

    private boolean isHidden(Parameter parameter) {
        return !CollectionUtils.isEmpty((Collection)parameter.getCapabilities(HiddenCapability.class));
    }

    private boolean isOperation(DataType type) {
        Object[] genericTypes = type.getGenericTypes();
        DataQualifier qualifier = type.getQualifier();
        return DataQualifier.OPERATION.equals((Object)qualifier) || DataQualifier.LIST.equals((Object)qualifier) && !ArrayUtils.isEmpty((Object[])genericTypes) && DataQualifier.OPERATION.equals((Object)genericTypes[0].getQualifier());
    }

    private void generateNestedProcessorElement(ExplicitGroup all, Operation operation, Parameter parameter, String maxOccurs) {
        LocalComplexType collectionComplexType = new LocalComplexType();
        GroupRef group = this.generateNestedProcessorGroup(operation, parameter, maxOccurs);
        collectionComplexType.setGroup(group);
        collectionComplexType.setAnnotation(this.createDocAnnotation(parameter.getDescription()));
        TopLevelElement collectionElement = new TopLevelElement();
        collectionElement.setName(NameUtils.hyphenize((String)parameter.getName()));
        collectionElement.setMinOccurs(parameter.isRequired() ? BigInteger.ONE : BigInteger.ZERO);
        collectionElement.setComplexType(collectionComplexType);
        collectionElement.setAnnotation(this.createDocAnnotation(""));
        all.getParticle().add(this.objectFactory.createElement(collectionElement));
    }

    private GroupRef generateNestedProcessorGroup(Operation operation, Parameter parameter, String maxOccurs) {
        QName ref = SchemaConstants.MULE_MESSAGE_PROCESSOR_OR_OUTBOUND_ENDPOINT_TYPE;
        TypeRestrictionCapability restrictionCapability = (TypeRestrictionCapability)CapabilityUtils.getSingleCapability((Capable)parameter, TypeRestrictionCapability.class);
        if (restrictionCapability != null) {
            ref = this.getSubstitutionGroup(operation, restrictionCapability.getType());
            ref = new QName(ref.getNamespaceURI(), this.getGroupName(ref.getLocalPart()), ref.getPrefix());
        }
        GroupRef group = new GroupRef();
        group.setRef(ref);
        group.setMinOccurs(parameter.isRequired() ? BigInteger.ONE : BigInteger.ZERO);
        group.setMaxOccurs(maxOccurs);
        return group;
    }

    private Attribute createAttribute(String name, String description, boolean optional, QName type) {
        Attribute attr = new Attribute();
        attr.setName(name);
        attr.setUse(optional ? "optional" : "required");
        attr.setType(type);
        if (description != null) {
            attr.setAnnotation(this.createDocAnnotation(description));
        }
        return attr;
    }

    private Annotation createDocAnnotation(String content) {
        if (StringUtils.isBlank((String)content)) {
            return null;
        }
        Annotation annotation = new Annotation();
        Documentation doc = new Documentation();
        doc.getContent().add(content);
        annotation.getAppinfoOrDocumentation().add(doc);
        return annotation;
    }

    private class ComplexTypeHolder {
        private ComplexType complexType;
        private DataType type;

        public ComplexTypeHolder(ComplexType complexType, DataType type) {
            this.complexType = complexType;
            this.type = type;
        }

        public ComplexType getComplexType() {
            return this.complexType;
        }

        public void setComplexType(ComplexType complexType) {
            this.complexType = complexType;
        }

        public DataType getType() {
            return this.type;
        }

        public void setType(DataType type) {
            this.type = type;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ComplexTypeHolder) {
                ComplexTypeHolder other = (ComplexTypeHolder)obj;
                return this.type.equals((Object)other.getType());
            }
            return false;
        }

        public int hashCode() {
            return this.type.hashCode();
        }
    }
}

