/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.api.component.config;

import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.util.Preconditions;

public class ComponentIdentifier {
    public static QName ANNOTATION_NAME = new QName("config", "componentIdentifier");
    public static QName ANNOTATION_PARAMETERS = new QName("config", "componentParameters");
    private String namespace;
    private String name;

    private ComponentIdentifier() {
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public static ComponentIdentifier parseComponentIdentifier(String componentIdentifier) {
        String identifier;
        String namespace;
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)componentIdentifier) ? 1 : 0) != 0, (String)"identifier cannot be an empty string or null");
        String[] values = componentIdentifier.split(":");
        if (values.length == 2) {
            namespace = values[0];
            identifier = values[1];
        } else {
            namespace = "mule";
            identifier = values[0];
        }
        return new Builder().withNamespace(namespace).withName(identifier).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentIdentifier that = (ComponentIdentifier)o;
        if (!this.namespace.equalsIgnoreCase(that.namespace)) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.namespace.toLowerCase().hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        return this.getNamespace().equals("mule") ? this.getName() : this.getNamespace() + ":" + this.getName();
    }

    public static class Builder {
        private ComponentIdentifier componentIdentifier = new ComponentIdentifier();

        public Builder withNamespace(String namespace) {
            this.componentIdentifier.namespace = namespace;
            return this;
        }

        public Builder withName(String identifier) {
            this.componentIdentifier.name = identifier;
            return this;
        }

        public ComponentIdentifier build() {
            Preconditions.checkState((this.componentIdentifier.namespace != null && !this.componentIdentifier.namespace.trim().isEmpty() ? 1 : 0) != 0, (String)"Namespace URI must be not blank");
            Preconditions.checkState((this.componentIdentifier.name != null && !this.componentIdentifier.name.trim().isEmpty() ? 1 : 0) != 0, (String)"Name must be not blank");
            return this.componentIdentifier;
        }
    }
}

