/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.api.component.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.dsl.api.component.config.ComponentIdentifier;

public class ComponentConfiguration {
    private ComponentIdentifier identifier;
    private Map<String, String> parameters = new HashMap<String, String>();
    private List<ComponentConfiguration> nestedComponents = new ArrayList<ComponentConfiguration>();
    private String value;

    public ComponentIdentifier getIdentifier() {
        return this.identifier;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public Optional<String> getValue() {
        return Optional.ofNullable(this.value);
    }

    public List<ComponentConfiguration> getNestedComponents() {
        return Collections.unmodifiableList(this.nestedComponents);
    }

    private ComponentConfiguration() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentConfiguration that = (ComponentConfiguration)o;
        if (!this.identifier.equals(that.identifier)) {
            return false;
        }
        if (!this.parameters.equals(that.parameters)) {
            return false;
        }
        return this.nestedComponents.equals(that.nestedComponents);
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + this.identifier.hashCode();
        result = 31 * result + this.parameters.hashCode();
        result = 31 * result + this.nestedComponents.hashCode();
        return result;
    }

    public static class Builder {
        private ComponentConfiguration componentConfiguration = new ComponentConfiguration();

        private Builder() {
        }

        public Builder withIdentifier(ComponentIdentifier identifier) {
            this.componentConfiguration.identifier = identifier;
            return this;
        }

        public Builder withParameter(String name, String value) {
            this.componentConfiguration.parameters.put(name, value);
            return this;
        }

        public Builder withValue(String textContent) {
            this.componentConfiguration.value = textContent;
            return this;
        }

        public Builder withNestedComponent(ComponentConfiguration nestedComponent) {
            this.componentConfiguration.nestedComponents.add(nestedComponent);
            return this;
        }

        public ComponentConfiguration build() {
            return this.componentConfiguration;
        }
    }
}

