/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth.processor;

import java.util.HashMap;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.security.oauth.OAuth1Adapter;
import org.mule.security.oauth.OAuth1Manager;
import org.mule.security.oauth.processor.AbstractAuthorizeMessageProcessor;
import org.mule.security.oauth.processor.OAuth1FetchAccessTokenMessageProcessor;

public abstract class BaseOAuth1AuthorizeMessageProcessor
extends AbstractAuthorizeMessageProcessor {
    private String requestTokenUrl = null;

    protected abstract Class<? extends OAuth1Adapter> getAdapterClass();

    @Override
    public void start() throws MuleException {
        super.start();
        OAuth1Adapter moduleObject = this.getAdapter();
        OAuth1Manager manager = moduleObject.getOauth1Manager();
        OAuth1FetchAccessTokenMessageProcessor fetchAccessTokenMessageProcessor = new OAuth1FetchAccessTokenMessageProcessor(moduleObject);
        if (this.getAccessTokenUrl() != null) {
            fetchAccessTokenMessageProcessor.setAccessTokenUrl(this.getAccessTokenUrl());
        } else {
            fetchAccessTokenMessageProcessor.setAccessTokenUrl(moduleObject.getAccessTokenUrl());
        }
        if (this.requestTokenUrl != null) {
            fetchAccessTokenMessageProcessor.setRequestTokenUrl(this.requestTokenUrl);
        } else {
            fetchAccessTokenMessageProcessor.setRequestTokenUrl(moduleObject.getRequestTokenUrl());
        }
        if (this.getAuthorizationUrl() != null) {
            fetchAccessTokenMessageProcessor.setAuthorizationUrl(this.getAuthorizationUrl());
        } else {
            fetchAccessTokenMessageProcessor.setAuthorizationUrl(moduleObject.getAuthorizationUrl());
        }
        this.startCallback(manager, fetchAccessTokenMessageProcessor);
    }

    @Override
    protected final MuleEvent doProcess(MuleEvent event) throws Exception {
        OAuth1Adapter moduleObject = this.getAdapter();
        HashMap<String, String> extraParameters = new HashMap<String, String>();
        if (this.getState() != null) {
            extraParameters.put("state", this.toString(event, this.getState()));
        }
        moduleObject.setAccessTokenUrl(this.toString(event, this.getAccessTokenUrl()));
        String location = moduleObject.authorize(extraParameters, this.requestTokenUrl, this.getAccessTokenUrl(), this.getAuthorizationUrl(), this.getOauthCallback().getUrl());
        this.notifyAuthorizeStart(event);
        event.getMessage().setOutboundProperty("http.status", (Object)"302");
        event.getMessage().setOutboundProperty("Location", (Object)location);
        return event;
    }

    protected OAuth1Adapter getAdapter() {
        try {
            Object maybeAnAdapter = this.findOrCreate(this.getAdapterClass(), false, null);
            if (!(maybeAnAdapter instanceof OAuth1Adapter)) {
                throw new IllegalStateException(String.format("Object of class %s does not implement OAuth1Adapter", this.getAdapterClass().getCanonicalName()));
            }
            return (OAuth1Adapter)maybeAnAdapter;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setRequestTokenUrl(String value) {
        this.requestTokenUrl = value;
    }

    public String getRequestTokenUrl() {
        return this.requestTokenUrl;
    }
}

