/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth;

import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreManager;
import org.mule.security.oauth.OAuth2Adapter;
import org.mule.security.oauth.RefreshTokenManager;

public class DefaultRefreshTokenManager
implements MuleContextAware,
RefreshTokenManager {
    private ObjectStore<Boolean> refreshedTokens;
    private MuleContext muleContext;
    private int minRefreshInterval = 60000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshToken(OAuth2Adapter adapter, String accessTokenId) throws Exception {
        if (StringUtils.isEmpty((String)accessTokenId)) {
            throw new IllegalArgumentException("Cannot refresh a blank accessTokenId");
        }
        String id = String.format("%s:%s:%s", this.getClass().getCanonicalName(), adapter.getName(), accessTokenId);
        Lock lock = this.muleContext.getLockFactory().createLock(id);
        lock.lock();
        try {
            if (!this.getRefreshedTokens().contains((Serializable)((Object)id))) {
                adapter.refreshAccessToken(accessTokenId);
                this.getRefreshedTokens().store((Serializable)((Object)id), (Serializable)Boolean.valueOf(true));
            }
        }
        finally {
            lock.unlock();
        }
    }

    private synchronized ObjectStore<Boolean> getRefreshedTokens() {
        if (this.refreshedTokens == null) {
            ObjectStoreManager osManager = this.muleContext.getObjectStoreManager();
            this.refreshedTokens = osManager.getObjectStore("RefreshTokenStore", false, -1, this.minRefreshInterval, this.minRefreshInterval);
        }
        return this.refreshedTokens;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public void setMinRefreshIntervalInMillis(int minRefreshIntervalInMillis) {
        this.minRefreshInterval = minRefreshIntervalInMillis;
    }
}

