/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.tooling;

import java.io.IOException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.util.UUID;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginRepository;
import org.mule.runtime.deployment.model.internal.AbstractArtifactClassLoaderBuilder;
import org.mule.runtime.deployment.model.internal.plugin.PluginDependenciesResolver;
import org.mule.runtime.deployment.model.internal.tooling.ToolingPluginArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.classloader.DeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptor;

public class ToolingPluginClassLoaderBuilder
extends AbstractArtifactClassLoaderBuilder<ToolingPluginClassLoaderBuilder> {
    private static final String TOOLING_EXTENSION_MODEL = "tooling-extension-model";
    private final DeployableArtifactClassLoaderFactory artifactClassLoaderFactory;
    private ArtifactPluginDescriptor artifactPluginDescriptor;
    private ArtifactClassLoader parentClassLoader;

    public ToolingPluginClassLoaderBuilder(DeployableArtifactClassLoaderFactory artifactClassLoaderFactory, ArtifactPluginRepository artifactPluginRepository, ArtifactClassLoaderFactory<ArtifactPluginDescriptor> artifactPluginClassLoaderFactory, ArtifactPluginDescriptor artifactPluginDescriptor, PluginDependenciesResolver pluginDependenciesResolver) {
        super(artifactPluginRepository, artifactPluginClassLoaderFactory, pluginDependenciesResolver);
        this.artifactPluginDescriptor = artifactPluginDescriptor;
        this.artifactClassLoaderFactory = artifactClassLoaderFactory;
    }

    @Override
    protected ArtifactClassLoader createArtifactClassLoader(String artifactId, RegionClassLoader regionClassLoader) {
        return this.artifactClassLoaderFactory.create(artifactId, (ArtifactClassLoader)regionClassLoader, this.artifactDescriptor, this.artifactPluginClassLoaders);
    }

    public ToolingPluginClassLoaderBuilder setParentClassLoader(ArtifactClassLoader parentClassLoader) {
        this.parentClassLoader = parentClassLoader;
        return this;
    }

    @Override
    protected ArtifactClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }

    @Override
    protected String getArtifactId(ArtifactDescriptor artifactDescriptor) {
        return TOOLING_EXTENSION_MODEL + UUID.getUUID() + "/" + artifactDescriptor.getName();
    }

    @Override
    public ArtifactClassLoader build() throws IOException {
        this.setArtifactDescriptor(new ArtifactDescriptor(TOOLING_EXTENSION_MODEL));
        this.addArtifactPluginDescriptors(this.artifactPluginDescriptor);
        ArtifactClassLoader ownerArtifactClassLoader = super.build();
        ClassLoader parent = ownerArtifactClassLoader.getClassLoader().getParent();
        if (!(parent instanceof RegionClassLoader)) {
            throw new DeploymentException(I18nMessageFactory.createStaticMessage((String)String.format("The parent of the current owner must be of type '%s' but found '%s'", RegionClassLoader.class.getName(), parent.getClass().getName())));
        }
        return new ToolingPluginArtifactClassLoader((RegionClassLoader)parent, this.artifactPluginDescriptor);
    }
}

