/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.tooling;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import org.mule.runtime.deployment.model.api.artifact.DependencyNotFoundException;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.classloader.ShutdownListener;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptor;

public class ToolingPluginArtifactClassLoader
implements ArtifactClassLoader {
    private final RegionClassLoader regionClassLoader;
    private final ArtifactClassLoader delegatePluginClassLoader;

    public ToolingPluginArtifactClassLoader(RegionClassLoader regionClassLoader, ArtifactPluginDescriptor artifactPluginDescriptor) {
        this.regionClassLoader = regionClassLoader;
        this.delegatePluginClassLoader = this.getPluginArtifactClassLoader(artifactPluginDescriptor, regionClassLoader.getArtifactPluginClassLoaders());
    }

    private ArtifactClassLoader getPluginArtifactClassLoader(ArtifactPluginDescriptor artifactPluginDescriptor, List<ArtifactClassLoader> artifactPluginClassLoaders) {
        return artifactPluginClassLoaders.stream().filter(artifactClassLoader -> artifactClassLoader.getArtifactId().endsWith("/plugin/" + artifactPluginDescriptor.getName())).findFirst().orElseThrow(() -> new DependencyNotFoundException(String.format("Cannot generate a tooling ClassLoader as the region ClassLoader is missing the plugin '%s'", artifactPluginDescriptor.getName())));
    }

    public String getArtifactId() {
        return this.delegatePluginClassLoader.getArtifactId();
    }

    public <T extends ArtifactDescriptor> T getArtifactDescriptor() {
        return (T)this.delegatePluginClassLoader.getArtifactDescriptor();
    }

    public URL findResource(String resource) {
        return this.delegatePluginClassLoader.findResource(resource);
    }

    public Enumeration<URL> findResources(String name) throws IOException {
        return this.delegatePluginClassLoader.findResources(name);
    }

    public Class<?> findLocalClass(String name) throws ClassNotFoundException {
        return this.delegatePluginClassLoader.findLocalClass(name);
    }

    public ClassLoader getClassLoader() {
        return this.delegatePluginClassLoader.getClassLoader();
    }

    public void addShutdownListener(ShutdownListener listener) {
        this.delegatePluginClassLoader.addShutdownListener(listener);
    }

    public ClassLoaderLookupPolicy getClassLoaderLookupPolicy() {
        return this.delegatePluginClassLoader.getClassLoaderLookupPolicy();
    }

    public URL findLocalResource(String resourceName) {
        return this.delegatePluginClassLoader.findLocalResource(resourceName);
    }

    public void dispose() {
        this.regionClassLoader.dispose();
    }
}

