/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.deployment.model.api.artifact.DependenciesProvider;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.plugin.DuplicateExportedPackageException;
import org.mule.runtime.deployment.model.internal.plugin.PluginDependenciesResolver;
import org.mule.runtime.deployment.model.internal.plugin.PluginResolutionError;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.descriptor.BundleDescriptorUtils;
import org.mule.runtime.module.artifact.descriptor.ClassLoaderModel;

public class BundlePluginDependenciesResolver
implements PluginDependenciesResolver {
    private final ArtifactDescriptorFactory<ArtifactPluginDescriptor> artifactDescriptorFactory;
    private final DependenciesProvider dependenciesProvider;

    public BundlePluginDependenciesResolver(ArtifactDescriptorFactory<ArtifactPluginDescriptor> artifactDescriptorFactory, DependenciesProvider dependenciesProvider) {
        this.artifactDescriptorFactory = artifactDescriptorFactory;
        this.dependenciesProvider = dependenciesProvider;
    }

    @Override
    public List<ArtifactPluginDescriptor> resolve(List<ArtifactPluginDescriptor> descriptors) {
        List<ArtifactPluginDescriptor> resolvedPlugins = this.resolvePluginsDependencies(descriptors);
        this.verifyPluginExportedPackages(resolvedPlugins);
        return resolvedPlugins;
    }

    private List<ArtifactPluginDescriptor> resolvePluginsDependencies(List<ArtifactPluginDescriptor> descriptors) {
        Set<BundleDescriptor> knownPlugins = descriptors.stream().map(ArtifactDescriptor::getBundleDescriptor).collect(Collectors.toSet());
        descriptors = this.getArtifactsWithDependencies(descriptors, knownPlugins);
        descriptors.sort((d1, d2) -> d1.getName().compareTo(d2.getName()));
        LinkedList<ArtifactPluginDescriptor> resolvedPlugins = new LinkedList<ArtifactPluginDescriptor>();
        LinkedList<ArtifactPluginDescriptor> unresolvedPlugins = new LinkedList<ArtifactPluginDescriptor>(descriptors);
        boolean continueResolution = true;
        while (continueResolution) {
            int initialResolvedCount = resolvedPlugins.size();
            LinkedList<ArtifactPluginDescriptor> pendingUnresolvedPlugins = new LinkedList<ArtifactPluginDescriptor>();
            for (ArtifactPluginDescriptor unresolvedPlugin : unresolvedPlugins) {
                if (this.isResolvedPlugin(unresolvedPlugin, resolvedPlugins)) {
                    this.sanitizeExportedPackages(unresolvedPlugin, resolvedPlugins);
                    resolvedPlugins.add(unresolvedPlugin);
                    continue;
                }
                pendingUnresolvedPlugins.add(unresolvedPlugin);
            }
            unresolvedPlugins = pendingUnresolvedPlugins;
            continueResolution = resolvedPlugins.size() > initialResolvedCount;
        }
        if (unresolvedPlugins.size() != 0) {
            throw new PluginResolutionError(BundlePluginDependenciesResolver.createResolutionErrorMessage(unresolvedPlugins, resolvedPlugins));
        }
        return resolvedPlugins;
    }

    private void verifyPluginExportedPackages(List<ArtifactPluginDescriptor> plugins) {
        HashMap<String, List<String>> exportedPackages = new HashMap<String, List<String>>();
        boolean error = false;
        for (ArtifactPluginDescriptor plugin : plugins) {
            for (String packageName : plugin.getClassLoaderModel().getExportedPackages()) {
                LinkedList<String> exportedOn = (LinkedList<String>)exportedPackages.get(packageName);
                if (exportedOn == null) {
                    exportedOn = new LinkedList<String>();
                    exportedPackages.put(packageName, exportedOn);
                } else {
                    error = true;
                }
                exportedOn.add(plugin.getName());
            }
        }
        if (error) {
            throw new DuplicateExportedPackageException(exportedPackages);
        }
    }

    private List<ArtifactPluginDescriptor> getArtifactsWithDependencies(List<ArtifactPluginDescriptor> pluginDescriptors, Set<BundleDescriptor> visited) {
        if (!pluginDescriptors.isEmpty()) {
            ArrayList<ArtifactPluginDescriptor> foundDependencies = new ArrayList<ArtifactPluginDescriptor>();
            pluginDescriptors.stream().filter(pluginDescriptor -> !pluginDescriptor.getClassLoaderModel().getDependencies().isEmpty()).forEach(pluginDescriptor -> pluginDescriptor.getClassLoaderModel().getDependencies().forEach(dependency -> {
                if (!this.isResolvedDependency(visited, dependency.getDescriptor())) {
                    File mulePluginLocation = this.dependenciesProvider.resolve(dependency.getDescriptor());
                    foundDependencies.add((ArtifactPluginDescriptor)this.artifactDescriptorFactory.create(new File(mulePluginLocation.toURI())));
                    visited.add(dependency.getDescriptor());
                }
            }));
            pluginDescriptors.addAll(this.getArtifactsWithDependencies(foundDependencies, visited));
        }
        return pluginDescriptors;
    }

    private void sanitizeExportedPackages(ArtifactPluginDescriptor pluginDescriptor, List<ArtifactPluginDescriptor> resolvedPlugins) {
        Set<String> packagesExportedByDependencies = this.findDependencyPackageClosure(pluginDescriptor.getClassLoaderModel().getDependencies(), resolvedPlugins);
        ClassLoaderModel originalClassLoaderModel = pluginDescriptor.getClassLoaderModel();
        HashSet exportedClassPackages = new HashSet(originalClassLoaderModel.getExportedPackages());
        exportedClassPackages.removeAll(packagesExportedByDependencies);
        pluginDescriptor.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder(originalClassLoaderModel).exportingPackages(exportedClassPackages).build());
    }

    private Set<String> findDependencyPackageClosure(Set<BundleDependency> pluginDependencies, List<ArtifactPluginDescriptor> resolvedPlugins) {
        HashSet<String> exportedPackages = new HashSet<String>();
        for (BundleDependency pluginDependency : pluginDependencies) {
            Optional classifier = pluginDependency.getDescriptor().getClassifier();
            if (!classifier.isPresent() || !"mule-plugin".equals(classifier.get())) continue;
            ArtifactPluginDescriptor dependencyDescriptor = BundlePluginDependenciesResolver.findArtifactPluginDescriptor(pluginDependency, resolvedPlugins);
            exportedPackages.addAll(dependencyDescriptor.getClassLoaderModel().getExportedPackages());
            exportedPackages.addAll(this.findDependencyPackageClosure(dependencyDescriptor.getClassLoaderModel().getDependencies(), resolvedPlugins));
        }
        return exportedPackages;
    }

    protected static String createResolutionErrorMessage(List<ArtifactPluginDescriptor> unresolvedPlugins, List<ArtifactPluginDescriptor> resolvedPlugins) {
        StringBuilder builder = new StringBuilder("Unable to resolve plugin dependencies:");
        for (ArtifactPluginDescriptor unresolvedPlugin : unresolvedPlugins) {
            builder.append("\nPlugin: ").append(unresolvedPlugin.getName()).append(" missing dependencies:");
            ArrayList<BundleDependency> missingDependencies = new ArrayList<BundleDependency>();
            for (BundleDependency dependency : unresolvedPlugin.getClassLoaderModel().getDependencies()) {
                ArtifactPluginDescriptor dependencyDescriptor;
                if (!"mule-plugin".equals(dependency.getDescriptor().getClassifier().get()) || (dependencyDescriptor = BundlePluginDependenciesResolver.findArtifactPluginDescriptor(dependency, resolvedPlugins)) != null) continue;
                missingDependencies.add(dependency);
            }
            builder.append(missingDependencies);
        }
        return builder.toString();
    }

    private boolean isResolvedDependency(Set<BundleDescriptor> visited, BundleDescriptor descriptor) {
        for (BundleDescriptor resolvedDependency : visited) {
            if (!BundlePluginDependenciesResolver.isResolvedDependency(resolvedDependency, descriptor)) continue;
            return true;
        }
        return false;
    }

    private boolean isResolvedPlugin(ArtifactPluginDescriptor descriptor, List<ArtifactPluginDescriptor> resolvedPlugins) {
        boolean isResolved = descriptor.getClassLoaderModel().getDependencies().isEmpty();
        if (!isResolved && this.hasPluginDependenciesResolved(descriptor.getClassLoaderModel().getDependencies(), resolvedPlugins)) {
            isResolved = true;
        }
        return isResolved;
    }

    private static ArtifactPluginDescriptor findArtifactPluginDescriptor(BundleDependency bundleDependency, List<ArtifactPluginDescriptor> resolvedPlugins) {
        ArtifactPluginDescriptor result = null;
        for (ArtifactPluginDescriptor resolvedPlugin : resolvedPlugins) {
            BundleDescriptor resolvedBundleDescriptor = resolvedPlugin.getBundleDescriptor();
            if (!BundlePluginDependenciesResolver.isResolvedDependency(resolvedBundleDescriptor, bundleDependency.getDescriptor())) continue;
            result = resolvedPlugin;
            break;
        }
        return result;
    }

    private static boolean isResolvedDependency(BundleDescriptor availableBundleDescriptor, BundleDescriptor expectedBundleDescriptor) {
        return availableBundleDescriptor.getArtifactId().equals(expectedBundleDescriptor.getArtifactId()) && availableBundleDescriptor.getGroupId().equals(expectedBundleDescriptor.getGroupId()) && BundleDescriptorUtils.isCompatibleVersion((String)availableBundleDescriptor.getVersion(), (String)expectedBundleDescriptor.getVersion());
    }

    private boolean hasPluginDependenciesResolved(Set<BundleDependency> pluginDependencies, List<ArtifactPluginDescriptor> resolvedPlugins) {
        boolean resolvedDependency = true;
        for (BundleDependency dependency : pluginDependencies) {
            if (BundlePluginDependenciesResolver.findArtifactPluginDescriptor(dependency, resolvedPlugins) != null) continue;
            resolvedDependency = false;
            break;
        }
        return resolvedDependency;
    }
}

