/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.nativelib;

import java.io.File;
import java.io.IOException;
import org.mule.runtime.core.util.FileUtils;
import org.mule.runtime.deployment.model.internal.nativelib.PerAppNativeLibraryFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerAppCopyNativeLibraryFinder
extends PerAppNativeLibraryFinder {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private final File perAppNativeLibs;

    public PerAppCopyNativeLibraryFinder(File libDir, File perAppNativeLibs) {
        super(libDir);
        this.perAppNativeLibs = perAppNativeLibs;
        if (this.perAppNativeLibs.exists()) {
            this.cleanNativeLibs();
        } else if (!this.perAppNativeLibs.mkdirs()) {
            throw new IllegalStateException(String.format("Unable to create application '%s' folder", this.perAppNativeLibs.getAbsolutePath()));
        }
    }

    @Override
    public String findLibrary(String name, String parentLibraryPath) {
        String libraryPath = parentLibraryPath;
        if (null == libraryPath) {
            libraryPath = this.findLibraryLocally(name);
        }
        if (libraryPath != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("Found native library for '%s' on '%s", name, libraryPath));
            }
            File tempLibrary = this.copyNativeLibrary(name, libraryPath);
            libraryPath = tempLibrary.getAbsolutePath();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("Created native library copy for '%s' on '%s", name, libraryPath));
            }
        }
        return libraryPath;
    }

    private void cleanNativeLibs() {
        String[] list = this.perAppNativeLibs.list();
        if (list != null) {
            for (String library : list) {
                new File(this.perAppNativeLibs, library).delete();
            }
        }
    }

    private File copyNativeLibrary(String name, String libraryPath) {
        String nativeLibName = System.mapLibraryName(name);
        File tempLibrary = new File(this.perAppNativeLibs, nativeLibName + System.currentTimeMillis());
        try {
            File library = new File(libraryPath);
            FileUtils.copyFile((File)library, (File)tempLibrary);
            return tempLibrary;
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Unable to generate copy for native library '%s' at '%s'", nativeLibName, tempLibrary.getAbsolutePath()), e);
        }
    }
}

