/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.domain;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.deployment.model.internal.domain.DomainClassLoaderFactory;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.reboot.MuleContainerBootstrapUtils;

public class MuleSharedDomainClassLoader
extends MuleArtifactClassLoader
implements ArtifactClassLoader {
    public MuleSharedDomainClassLoader(ArtifactDescriptor artifactDescriptor, ClassLoader parent, ClassLoaderLookupPolicy lookupPolicy, List<URL> urls) {
        super(DomainClassLoaderFactory.getDomainId(artifactDescriptor.getName()), artifactDescriptor, urls.toArray(new URL[0]), parent, lookupPolicy);
    }

    public URL findResource(String name) {
        File file;
        URL resource = super.findResource(name);
        if (resource == null && (file = new File(MuleFoldersUtil.getDomainFolder((String)this.getArtifactDescriptor().getName()) + File.separator + name)).exists()) {
            try {
                resource = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                this.logger.debug("Failure looking for resource", (Throwable)e);
            }
        }
        return resource;
    }

    protected String[] getLocalResourceLocations() {
        return new String[]{MuleFoldersUtil.getDomainFolder((String)this.getArtifactDescriptor().getName()).getAbsolutePath(), MuleContainerBootstrapUtils.getMuleConfDir().getAbsolutePath()};
    }

    static {
        MuleSharedDomainClassLoader.registerAsParallelCapable();
    }
}

