/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.domain;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.domain.DomainDescriptor;
import org.mule.runtime.deployment.model.internal.domain.MuleSharedDomainClassLoader;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.classloader.ClassLoaderLookupStrategy;
import org.mule.runtime.module.artifact.classloader.DeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.classloader.ShutdownListener;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.util.FileJarExplorer;
import org.mule.runtime.module.artifact.util.JarExplorer;
import org.mule.runtime.module.reboot.MuleContainerBootstrapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainClassLoaderFactory
implements DeployableArtifactClassLoaderFactory<DomainDescriptor> {
    protected static final Logger logger = LoggerFactory.getLogger(DomainClassLoaderFactory.class);
    private final ClassLoader parentClassLoader;
    private Map<String, ArtifactClassLoader> domainArtifactClassLoaders = new HashMap<String, ArtifactClassLoader>();
    private JarExplorer jarExplorer = new FileJarExplorer();

    public DomainClassLoaderFactory(ClassLoader parentClassLoader) {
        Preconditions.checkArgument((parentClassLoader != null ? 1 : 0) != 0, (String)"parentClassLoader cannot be null");
        this.parentClassLoader = parentClassLoader;
    }

    public void setJarExplorer(JarExplorer jarExplorer) {
        this.jarExplorer = jarExplorer;
    }

    public static String getDomainId(String domainName) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)domainName) ? 1 : 0) != 0, (String)"domainName cannot be empty");
        return "domain/" + domainName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArtifactClassLoader create(String artifactId, ArtifactClassLoader parent, DomainDescriptor descriptor, List<ArtifactClassLoader> artifactClassLoaders) {
        String domainId = DomainClassLoaderFactory.getDomainId(descriptor.getName());
        ArtifactClassLoader domainClassLoader = this.domainArtifactClassLoaders.get(domainId);
        if (domainClassLoader != null) {
            return domainClassLoader;
        }
        DomainClassLoaderFactory domainClassLoaderFactory = this;
        synchronized (domainClassLoaderFactory) {
            domainClassLoader = this.domainArtifactClassLoaders.get(domainId);
            if (domainClassLoader == null) {
                domainClassLoader = descriptor.getName().equals("default") ? this.getDefaultDomainClassLoader(parent.getClassLoaderLookupPolicy()) : this.getCustomDomainClassLoader(parent.getClassLoaderLookupPolicy(), descriptor);
                this.domainArtifactClassLoaders.put(domainId, domainClassLoader);
            }
        }
        return domainClassLoader;
    }

    private ArtifactClassLoader getCustomDomainClassLoader(ClassLoaderLookupPolicy containerLookupPolicy, DomainDescriptor domain) {
        this.validateDomain(domain.getName());
        List<URL> urls = this.getDomainUrls(domain.getName());
        Map<String, ClassLoaderLookupStrategy> domainLookStrategies = this.getLookStrategiesFrom(urls);
        ClassLoaderLookupPolicy domainLookupPolicy = containerLookupPolicy.extend(domainLookStrategies);
        MuleSharedDomainClassLoader classLoader = new MuleSharedDomainClassLoader(domain, this.parentClassLoader, domainLookupPolicy, urls);
        return this.createClassLoaderUnregisterWrapper(classLoader);
    }

    private Map<String, ClassLoaderLookupStrategy> getLookStrategiesFrom(List<URL> libraries) {
        HashMap<String, ClassLoaderLookupStrategy> result = new HashMap<String, ClassLoaderLookupStrategy>();
        for (URL library : libraries) {
            Set packages = this.jarExplorer.explore(library).getPackages();
            for (String packageName : packages) {
                result.put(packageName, ClassLoaderLookupStrategy.PARENT_FIRST);
            }
        }
        return result;
    }

    private List<URL> getDomainUrls(String domain) throws DeploymentException {
        try {
            LinkedList<URL> urls = new LinkedList<URL>();
            urls.add(MuleFoldersUtil.getDomainFolder((String)domain).toURI().toURL());
            File domainLibraryFolder = MuleFoldersUtil.getDomainLibFolder((String)domain);
            if (domainLibraryFolder.exists()) {
                Collection jars = FileUtils.listFiles((File)domainLibraryFolder, (String[])new String[]{"jar"}, (boolean)false);
                if (logger.isDebugEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Loading Shared ClassLoader Domain: ").append(domain).append(SystemUtils.LINE_SEPARATOR);
                    sb.append("=============================").append(SystemUtils.LINE_SEPARATOR);
                    for (File jar : jars) {
                        sb.append(jar.toURI().toURL()).append(SystemUtils.LINE_SEPARATOR);
                    }
                    sb.append("=============================").append(SystemUtils.LINE_SEPARATOR);
                    logger.debug(sb.toString());
                }
                for (File jar : jars) {
                    urls.add(jar.toURI().toURL());
                }
            }
            return urls;
        }
        catch (MalformedURLException e) {
            throw new DeploymentException(I18nMessageFactory.createStaticMessage((String)String.format("Cannot read domain '%s' libraries", domain)), e);
        }
    }

    private ArtifactClassLoader getDefaultDomainClassLoader(ClassLoaderLookupPolicy containerLookupPolicy) {
        return new MuleSharedDomainClassLoader(new DomainDescriptor("default"), this.parentClassLoader, containerLookupPolicy.extend(Collections.emptyMap()), Collections.emptyList());
    }

    private void validateDomain(String domain) {
        File domainFolder = new File(MuleContainerBootstrapUtils.getMuleDomainsDir(), domain);
        if (!domainFolder.exists() || !domainFolder.isDirectory()) {
            throw new DeploymentException(I18nMessageFactory.createStaticMessage((String)String.format("Domain %s does not exists", domain)));
        }
    }

    private ArtifactClassLoader createClassLoaderUnregisterWrapper(final ArtifactClassLoader classLoader) {
        return new ArtifactClassLoader(){

            public String getArtifactId() {
                return classLoader.getArtifactId();
            }

            public <T extends ArtifactDescriptor> T getArtifactDescriptor() {
                return (T)classLoader.getArtifactDescriptor();
            }

            public URL findResource(String resource) {
                return classLoader.findResource(resource);
            }

            public Enumeration<URL> findResources(String name) throws IOException {
                return classLoader.findResources(name);
            }

            public Class<?> findLocalClass(String name) throws ClassNotFoundException {
                return classLoader.findLocalClass(name);
            }

            public URL findLocalResource(String resource) {
                return classLoader.findLocalResource(resource);
            }

            public ClassLoader getClassLoader() {
                return classLoader.getClassLoader();
            }

            public void dispose() {
                DomainClassLoaderFactory.this.domainArtifactClassLoaders.remove(classLoader.getArtifactId());
                classLoader.dispose();
            }

            public void addShutdownListener(ShutdownListener listener) {
                classLoader.addShutdownListener(listener);
            }

            public ClassLoaderLookupPolicy getClassLoaderLookupPolicy() {
                return classLoader.getClassLoaderLookupPolicy();
            }
        };
    }
}

