/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.util.UUID;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginRepository;
import org.mule.runtime.deployment.model.internal.plugin.PluginDependenciesResolver;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoaderFilter;
import org.mule.runtime.module.artifact.classloader.DefaultArtifactClassLoaderFilter;
import org.mule.runtime.module.artifact.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.descriptor.ClassLoaderModel;

public abstract class AbstractArtifactClassLoaderBuilder<T extends AbstractArtifactClassLoaderBuilder> {
    private final ArtifactPluginRepository artifactPluginRepository;
    protected final ArtifactClassLoaderFactory artifactPluginClassLoaderFactory;
    private final PluginDependenciesResolver pluginDependenciesResolver;
    private Set<ArtifactPluginDescriptor> artifactPluginDescriptors = new HashSet<ArtifactPluginDescriptor>();
    private String artifactId = UUID.getUUID();
    protected ArtifactDescriptor artifactDescriptor;
    private ArtifactClassLoader parentClassLoader;
    protected List<ArtifactClassLoader> artifactPluginClassLoaders = new ArrayList<ArtifactClassLoader>();

    public AbstractArtifactClassLoaderBuilder(ArtifactPluginRepository artifactPluginRepository, ArtifactClassLoaderFactory<ArtifactPluginDescriptor> artifactPluginClassLoaderFactory, PluginDependenciesResolver pluginDependenciesResolver) {
        Preconditions.checkArgument((artifactPluginRepository != null ? 1 : 0) != 0, (String)"artifact plugin repository cannot be null");
        Preconditions.checkArgument((artifactPluginClassLoaderFactory != null ? 1 : 0) != 0, (String)"artifactPluginClassLoaderFactory cannot be null");
        Preconditions.checkArgument((pluginDependenciesResolver != null ? 1 : 0) != 0, (String)"pluginDependenciesResolver cannot be null");
        this.artifactPluginRepository = artifactPluginRepository;
        this.artifactPluginClassLoaderFactory = artifactPluginClassLoaderFactory;
        this.pluginDependenciesResolver = pluginDependenciesResolver;
    }

    protected abstract ArtifactClassLoader getParentClassLoader();

    public T setArtifactId(String artifactId) {
        Preconditions.checkArgument((artifactId != null ? 1 : 0) != 0, (String)"artifact id cannot be null");
        this.artifactId = artifactId;
        return (T)this;
    }

    public T addArtifactPluginDescriptors(ArtifactPluginDescriptor ... artifactPluginDescriptors) {
        Preconditions.checkArgument((artifactPluginDescriptors != null ? 1 : 0) != 0, (String)"artifact plugin descriptors cannot be null");
        this.artifactPluginDescriptors.addAll(Arrays.asList(artifactPluginDescriptors));
        return (T)this;
    }

    public T setArtifactDescriptor(ArtifactDescriptor artifactDescriptor) {
        this.artifactDescriptor = artifactDescriptor;
        return (T)this;
    }

    public ArtifactClassLoader build() throws IOException {
        Preconditions.checkState((this.artifactDescriptor != null ? 1 : 0) != 0, (String)"artifact descriptor cannot be null");
        this.parentClassLoader = this.getParentClassLoader();
        Preconditions.checkState((this.parentClassLoader != null ? 1 : 0) != 0, (String)"parent class loader cannot be null");
        String artifactId = this.getArtifactId(this.artifactDescriptor);
        RegionClassLoader regionClassLoader = new RegionClassLoader(artifactId, this.artifactDescriptor, this.parentClassLoader.getClassLoader(), this.parentClassLoader.getClassLoaderLookupPolicy());
        List<ArtifactPluginDescriptor> pluginDescriptors = this.createContainerApplicationPlugins();
        pluginDescriptors.addAll(this.artifactPluginDescriptors);
        List<ArtifactPluginDescriptor> effectiveArtifactPluginDescriptors = this.pluginDependenciesResolver.resolve(pluginDescriptors);
        List<ArtifactClassLoader> pluginClassLoaders = this.createPluginClassLoaders(artifactId, (ArtifactClassLoader)regionClassLoader, effectiveArtifactPluginDescriptors);
        ArtifactClassLoader artifactClassLoader = this.createArtifactClassLoader(artifactId, regionClassLoader);
        ArtifactClassLoaderFilter artifactClassLoaderFilter = this.createClassLoaderFilter(this.artifactDescriptor.getClassLoaderModel());
        regionClassLoader.addClassLoader(artifactClassLoader, artifactClassLoaderFilter);
        for (int i = 0; i < effectiveArtifactPluginDescriptors.size(); ++i) {
            ArtifactClassLoaderFilter classLoaderFilter = this.createClassLoaderFilter(effectiveArtifactPluginDescriptors.get(i).getClassLoaderModel());
            regionClassLoader.addClassLoader(pluginClassLoaders.get(i), classLoaderFilter);
        }
        return artifactClassLoader;
    }

    protected abstract ArtifactClassLoader createArtifactClassLoader(String var1, RegionClassLoader var2);

    private ArtifactClassLoaderFilter createClassLoaderFilter(ClassLoaderModel classLoaderModel) {
        return new DefaultArtifactClassLoaderFilter(classLoaderModel.getExportedPackages(), classLoaderModel.getExportedResources());
    }

    protected abstract String getArtifactId(ArtifactDescriptor var1);

    private List<ArtifactPluginDescriptor> createContainerApplicationPlugins() {
        LinkedList<ArtifactPluginDescriptor> containerPlugins = new LinkedList<ArtifactPluginDescriptor>();
        for (ArtifactPluginDescriptor appPluginDescriptor : this.artifactPluginRepository.getContainerArtifactPluginDescriptors()) {
            if (this.containsApplicationPluginDescriptor(appPluginDescriptor)) {
                String msg = String.format("Failed to deploy artifact [%s], plugin [%s] is already bundled within the container and cannot be included in artifact", this.artifactId, appPluginDescriptor.getName());
                throw new DeploymentException(I18nMessageFactory.createStaticMessage((String)msg));
            }
            containerPlugins.add(appPluginDescriptor);
        }
        return containerPlugins;
    }

    private boolean containsApplicationPluginDescriptor(ArtifactPluginDescriptor appPluginDescriptor) {
        return CollectionUtils.find(this.artifactPluginDescriptors, object -> ((ArtifactPluginDescriptor)((Object)((Object)object))).getName().equals(appPluginDescriptor.getName())) != null;
    }

    private List<ArtifactClassLoader> createPluginClassLoaders(String artifactId, ArtifactClassLoader parent, List<ArtifactPluginDescriptor> artifactPluginDescriptors) {
        LinkedList<ArtifactClassLoader> classLoaders = new LinkedList<ArtifactClassLoader>();
        for (ArtifactPluginDescriptor artifactPluginDescriptor : artifactPluginDescriptors) {
            artifactPluginDescriptor.setArtifactPluginDescriptors(artifactPluginDescriptors);
            String pluginArtifactId = AbstractArtifactClassLoaderBuilder.getArtifactPluginId(artifactId, artifactPluginDescriptor.getName());
            ArtifactClassLoader artifactClassLoader = this.artifactPluginClassLoaderFactory.create(pluginArtifactId, parent, (ArtifactDescriptor)artifactPluginDescriptor);
            this.artifactPluginClassLoaders.add(artifactClassLoader);
            classLoaders.add(artifactClassLoader);
        }
        return classLoaders;
    }

    public static String getArtifactPluginId(String parentArtifactId, String pluginName) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)parentArtifactId) ? 1 : 0) != 0, (String)"parentArtifactId cannot be empty");
        Preconditions.checkArgument((!StringUtils.isEmpty((String)pluginName) ? 1 : 0) != 0, (String)"pluginName cannot be empty");
        return parentArtifactId + "/plugin/" + pluginName;
    }
}

