/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.api.plugin;

import java.util.HashMap;
import java.util.Set;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.classloader.ClassLoaderLookupStrategy;
import org.mule.runtime.module.artifact.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.descriptor.BundleDependency;

public class ArtifactPluginClassLoaderFactory
implements ArtifactClassLoaderFactory<ArtifactPluginDescriptor> {
    public ArtifactClassLoader create(String artifactId, ArtifactClassLoader parent, ArtifactPluginDescriptor descriptor) {
        HashMap<String, ClassLoaderLookupStrategy> pluginsLookupPolicies = new HashMap<String, ClassLoaderLookupStrategy>();
        for (ArtifactPluginDescriptor dependencyPluginDescriptor : descriptor.getArtifactPluginDescriptors()) {
            if (dependencyPluginDescriptor.getName().equals(descriptor.getName())) continue;
            ClassLoaderLookupStrategy parentFirst = this.getClassLoaderLookupStrategy(descriptor, dependencyPluginDescriptor);
            for (String exportedPackage : dependencyPluginDescriptor.getClassLoaderModel().getExportedPackages()) {
                pluginsLookupPolicies.put(exportedPackage, parentFirst);
            }
        }
        ClassLoaderLookupPolicy lookupPolicy = parent.getClassLoaderLookupPolicy().extend(pluginsLookupPolicies);
        return new MuleArtifactClassLoader(artifactId, (ArtifactDescriptor)descriptor, descriptor.getClassLoaderModel().getUrls(), parent.getClassLoader(), lookupPolicy);
    }

    private ClassLoaderLookupStrategy getClassLoaderLookupStrategy(ArtifactPluginDescriptor descriptor, ArtifactPluginDescriptor dependencyPluginDescriptor) {
        ClassLoaderLookupStrategy parentFirst = this.isDependencyPlugin(descriptor.getClassLoaderModel().getDependencies(), dependencyPluginDescriptor) ? ClassLoaderLookupStrategy.PARENT_FIRST : ClassLoaderLookupStrategy.CHILD_ONLY;
        return parentFirst;
    }

    private boolean isDependencyPlugin(Set<BundleDependency> pluginDependencies, ArtifactPluginDescriptor dependencyPluginDescriptor) {
        for (BundleDependency pluginDependency : pluginDependencies) {
            if (!pluginDependency.getDescriptor().getArtifactId().equals(dependencyPluginDescriptor.getBundleDescriptor().getArtifactId()) || !"mule-plugin".equals(pluginDependency.getDescriptor().getClassifier().get())) continue;
            return true;
        }
        return false;
    }
}

