/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.result.statement;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.mule.extension.db.internal.domain.connection.DbConnection;
import org.mule.extension.db.internal.result.resultset.StreamingResultSetCloser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractStreamingResultSetCloser
implements StreamingResultSetCloser {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractStreamingResultSetCloser.class);
    private final boolean autoCloseConnection;

    public AbstractStreamingResultSetCloser() {
        this(true);
    }

    public AbstractStreamingResultSetCloser(boolean autoClose) {
        this.autoCloseConnection = autoClose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(DbConnection connection, ResultSet resultSet) {
        try {
            resultSet.close();
        }
        catch (SQLException e) {
            LOGGER.warn("Error attempting to close resultSet", (Throwable)e);
        }
        finally {
            connection.endStreaming();
            if (this.autoCloseConnection) {
                connection.release();
            }
        }
    }
}

