/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.result.resultset;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.mule.extension.db.internal.domain.connection.DbConnection;
import org.mule.extension.db.internal.result.resultset.StreamingResultSetCloser;
import org.mule.extension.db.internal.result.row.RowHandler;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.Closeable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetIterator
implements Iterator<Map<String, Object>>,
Closeable {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ResultSetIterator.class);
    private final ResultSet resultSet;
    private final RowHandler rowHandler;
    private final StreamingResultSetCloser streamingResultSetCloser;
    private DbConnection connection;
    private Boolean cachedNext = null;

    public ResultSetIterator(DbConnection connection, ResultSet resultSet, RowHandler rowHandler, StreamingResultSetCloser streamingResultSetCloser) {
        if (connection == null) {
            throw new NullPointerException();
        }
        this.resultSet = resultSet;
        this.rowHandler = rowHandler;
        this.streamingResultSetCloser = streamingResultSetCloser;
        this.connection = connection;
    }

    @Override
    public boolean hasNext() {
        boolean result = false;
        if (this.cachedNext == null) {
            block8: {
                try {
                    this.cachedNext = this.resultSet.next();
                    result = this.cachedNext;
                }
                catch (SQLException e) {
                    if (!LOGGER.isDebugEnabled()) break block8;
                    LOGGER.debug("Unable to determine if there are more records", (Throwable)e);
                }
            }
            if (!result) {
                try {
                    this.close();
                }
                catch (MuleException e) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Error closing resultset", (Throwable)e);
                    }
                }
            }
        } else {
            result = this.cachedNext;
        }
        return result;
    }

    @Override
    public Map<String, Object> next() {
        try {
            if (this.cachedNext == null) {
                this.resultSet.next();
            } else {
                this.cachedNext = null;
            }
            return this.rowHandler.process(this.resultSet);
        }
        catch (SQLException e) {
            LOGGER.warn("Unable to obtain next row", (Throwable)e);
            throw new NoSuchElementException();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() throws MuleException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Closing resultSet");
        }
        this.streamingResultSetCloser.close(this.connection, this.resultSet);
    }
}

