/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.result.resultset;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.mule.extension.db.internal.StatementStreamingResultSetCloser;
import org.mule.extension.db.internal.domain.connection.DbConnection;
import org.mule.extension.db.internal.result.resultset.ResultSetHandler;
import org.mule.extension.db.internal.result.resultset.ResultSetIterator;
import org.mule.extension.db.internal.result.row.RowHandler;

public class IteratorResultSetHandler
implements ResultSetHandler {
    private final RowHandler rowHandler;
    private final StatementStreamingResultSetCloser streamingResultSetCloser;

    public IteratorResultSetHandler(RowHandler rowHandler, StatementStreamingResultSetCloser streamingResultSetCloser) {
        this.rowHandler = rowHandler;
        this.streamingResultSetCloser = streamingResultSetCloser;
    }

    @Override
    public ResultSetIterator processResultSet(DbConnection connection, ResultSet resultSet) throws SQLException {
        this.streamingResultSetCloser.trackResultSet(connection, resultSet);
        connection.beginStreaming();
        return new ResultSetIterator(connection, resultSet, this.rowHandler, this.streamingResultSetCloser);
    }

    @Override
    public boolean requiresMultipleOpenedResults() {
        return true;
    }
}

