/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.resolver.query;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.extension.db.api.param.OutputParameter;
import org.mule.extension.db.api.param.ParameterType;
import org.mule.extension.db.api.param.StoredProcedureCall;
import org.mule.extension.db.internal.DbConnector;
import org.mule.extension.db.internal.domain.connection.DbConnection;
import org.mule.extension.db.internal.domain.param.DefaultInOutQueryParam;
import org.mule.extension.db.internal.domain.param.DefaultInputQueryParam;
import org.mule.extension.db.internal.domain.param.DefaultOutputQueryParam;
import org.mule.extension.db.internal.domain.param.QueryParam;
import org.mule.extension.db.internal.domain.query.QueryTemplate;
import org.mule.extension.db.internal.domain.type.DbType;
import org.mule.extension.db.internal.domain.type.DbTypeManager;
import org.mule.extension.db.internal.domain.type.DynamicDbType;
import org.mule.extension.db.internal.resolver.query.ParameterizedQueryResolver;

public class StoredProcedureQueryResolver
extends ParameterizedQueryResolver<StoredProcedureCall> {
    @Override
    protected QueryTemplate createQueryTemplate(StoredProcedureCall call, DbConnector connector, DbConnection connection) {
        QueryTemplate queryTemplate = super.createQueryTemplate(call, connector, connection);
        return new QueryTemplate(queryTemplate.getSqlText(), queryTemplate.getType(), this.resolveParamTypes(queryTemplate, call, connector, connection), queryTemplate.isDynamic());
    }

    private List<QueryParam> resolveParamTypes(QueryTemplate queryTemplate, StoredProcedureCall call, DbConnector connector, DbConnection connection) {
        DbTypeManager typeManager = this.createTypeManager(connector, connection);
        return queryTemplate.getParams().stream().map(param -> {
            String paramName = param.getName();
            Optional<OutputParameter> outputParameter = call.getOutputParameter(paramName);
            if (outputParameter.isPresent()) {
                DbType type;
                ParameterType parameterType = outputParameter.get();
                DbType dbType = type = parameterType.getDbType() != null ? parameterType.getDbType() : param.getType();
                if (type instanceof DynamicDbType) {
                    type = typeManager.lookup(connection, type.getName());
                }
                return new DefaultOutputQueryParam(param.getIndex(), type, paramName);
            }
            Optional<Object> parameterValue = call.getInputParameter(paramName);
            if (parameterValue.isPresent()) {
                return new DefaultInputQueryParam(param.getIndex(), param.getType(), parameterValue.get(), paramName);
            }
            parameterValue = call.getInOutParameter(paramName);
            if (parameterValue.isPresent()) {
                return new DefaultInOutQueryParam(param.getIndex(), param.getType(), paramName, parameterValue.get());
            }
            throw new IllegalArgumentException(String.format("Parameter '%s' was not bound for query '%s'", paramName, call.getSql()));
        }).collect(Collectors.toCollection(LinkedList::new));
    }

    @Override
    protected Optional<Object> getInputParameter(StoredProcedureCall statementDefinition, String parameterName) {
        Optional<Object> value = super.getInputParameter(statementDefinition, parameterName);
        if (!value.isPresent()) {
            value = statementDefinition.getInOutParameter(parameterName);
        }
        return value;
    }
}

