/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.resolver.query;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.extension.db.api.param.ParameterizedStatementDefinition;
import org.mule.extension.db.internal.domain.query.QueryParamValue;
import org.mule.extension.db.internal.domain.query.QueryTemplate;
import org.mule.extension.db.internal.resolver.query.AbstractQueryResolver;

public class ParameterizedQueryResolver<T extends ParameterizedStatementDefinition>
extends AbstractQueryResolver<T> {
    @Override
    protected List<QueryParamValue> resolveParams(T statementDefinition, QueryTemplate template) {
        return template.getInputParams().stream().map(p -> {
            String parameterName = p.getName();
            Optional<Object> parameterValue = this.getInputParameter(statementDefinition, parameterName);
            if (parameterValue.isPresent()) {
                return new QueryParamValue(parameterName, parameterValue.get());
            }
            throw new IllegalArgumentException(String.format("Parameter '%s' was not bound for query '%s'", parameterName, statementDefinition.getSql()));
        }).collect(Collectors.toList());
    }

    protected Optional<Object> getInputParameter(T statementDefinition, String parameterName) {
        return ((ParameterizedStatementDefinition)statementDefinition).getInputParameter(parameterName);
    }
}

