/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.resolver.query;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.mule.extension.db.api.param.BulkQueryDefinition;
import org.mule.extension.db.api.param.ParameterType;
import org.mule.extension.db.internal.DbConnector;
import org.mule.extension.db.internal.domain.connection.DbConnection;
import org.mule.extension.db.internal.domain.param.DefaultInputQueryParam;
import org.mule.extension.db.internal.domain.param.InputQueryParam;
import org.mule.extension.db.internal.domain.param.QueryParam;
import org.mule.extension.db.internal.domain.query.Query;
import org.mule.extension.db.internal.domain.query.QueryParamValue;
import org.mule.extension.db.internal.domain.query.QueryTemplate;
import org.mule.extension.db.internal.resolver.query.AbstractQueryResolver;

public class BulkQueryResolver
extends AbstractQueryResolver<BulkQueryDefinition> {
    @Override
    public Query resolve(BulkQueryDefinition definition, DbConnector connector, DbConnection connection) {
        Query query = super.resolve(definition, connector, connection);
        LinkedList<QueryParam> queryParams = new LinkedList<QueryParam>();
        QueryTemplate queryTemplate = query.getQueryTemplate();
        queryTemplate.getParams().forEach(inputParam -> {
            String paramName;
            Optional<ParameterType> parameterType;
            if (inputParam instanceof InputQueryParam && (parameterType = definition.getParameterType(paramName = inputParam.getName())).isPresent()) {
                queryParams.add(new DefaultInputQueryParam(inputParam.getIndex(), parameterType.get().getDbType(), null, paramName));
                return;
            }
            queryParams.add((QueryParam)inputParam);
        });
        return new Query(new QueryTemplate(queryTemplate.getSqlText(), queryTemplate.getType(), queryParams, queryTemplate.isDynamic()));
    }

    @Override
    protected List<QueryParamValue> resolveParams(BulkQueryDefinition statementDefinition, QueryTemplate template) {
        return new LinkedList<QueryParamValue>();
    }
}

