/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.resolver.query;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.mule.extension.db.api.param.StatementDefinition;
import org.mule.extension.db.internal.DbConnector;
import org.mule.extension.db.internal.domain.connection.DbConnection;
import org.mule.extension.db.internal.domain.param.AbstractQueryParam;
import org.mule.extension.db.internal.domain.param.DefaultInOutQueryParam;
import org.mule.extension.db.internal.domain.param.DefaultInputQueryParam;
import org.mule.extension.db.internal.domain.param.DefaultOutputQueryParam;
import org.mule.extension.db.internal.domain.param.InOutQueryParam;
import org.mule.extension.db.internal.domain.param.InputQueryParam;
import org.mule.extension.db.internal.domain.param.OutputQueryParam;
import org.mule.extension.db.internal.domain.param.QueryParam;
import org.mule.extension.db.internal.domain.query.Query;
import org.mule.extension.db.internal.domain.query.QueryParamValue;
import org.mule.extension.db.internal.domain.query.QueryTemplate;
import org.mule.extension.db.internal.domain.type.CompositeDbTypeManager;
import org.mule.extension.db.internal.domain.type.DbType;
import org.mule.extension.db.internal.domain.type.DbTypeManager;
import org.mule.extension.db.internal.domain.type.DynamicDbType;
import org.mule.extension.db.internal.domain.type.StaticDbTypeManager;
import org.mule.extension.db.internal.domain.type.UnknownDbType;
import org.mule.extension.db.internal.parser.QueryTemplateParser;
import org.mule.extension.db.internal.parser.SimpleQueryTemplateParser;
import org.mule.extension.db.internal.resolver.param.GenericParamTypeResolverFactory;
import org.mule.extension.db.internal.resolver.query.QueryResolutionException;
import org.mule.extension.db.internal.resolver.query.QueryResolver;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;

abstract class AbstractQueryResolver<T extends StatementDefinition>
implements QueryResolver<T> {
    protected Cache<String, QueryTemplate> queryTemplates = CacheBuilder.newBuilder().build();
    private QueryTemplateParser queryTemplateParser = new SimpleQueryTemplateParser();

    AbstractQueryResolver() {
    }

    @Override
    public Query resolve(T statementDefinition, DbConnector connector, DbConnection connection) {
        Preconditions.checkArgument((!StringUtils.isBlank((String)((StatementDefinition)(statementDefinition = ((StatementDefinition)statementDefinition).resolveFromTemplate())).getSql()) ? 1 : 0) != 0, (String)"sql query cannot be blank");
        QueryTemplate queryTemplate = this.getQueryTemplate(connector, connection, statementDefinition);
        return new Query(queryTemplate, this.resolveParams(statementDefinition, queryTemplate));
    }

    protected abstract List<QueryParamValue> resolveParams(T var1, QueryTemplate var2);

    protected QueryTemplate createQueryTemplate(T statementDefinition, DbConnector connector, DbConnection connection) {
        if (StringUtils.isBlank((String)((StatementDefinition)statementDefinition).getSql())) {
            throw new IllegalArgumentException("Statement doesn't contain a SQL query. Please provide one or reference a template which does");
        }
        QueryTemplate queryTemplate = this.queryTemplateParser.parse(((StatementDefinition)statementDefinition).getSql());
        if (this.needsParamTypeResolution(queryTemplate)) {
            Map<Integer, DbType> paramTypes = this.getParameterTypes(connector, connection, queryTemplate);
            queryTemplate = this.resolveQueryTemplate(queryTemplate, paramTypes);
        }
        return queryTemplate;
    }

    private Map<Integer, DbType> getParameterTypes(DbConnector connector, DbConnection connection, QueryTemplate queryTemplate) {
        GenericParamTypeResolverFactory paramTypeResolverFactory = new GenericParamTypeResolverFactory(this.createTypeManager(connector, connection));
        try {
            return paramTypeResolverFactory.create(queryTemplate).getParameterTypes(connection, queryTemplate);
        }
        catch (SQLException e) {
            throw new QueryResolutionException("Cannot resolve parameter types", e);
        }
    }

    private QueryTemplate getQueryTemplate(DbConnector connector, DbConnection connection, T statementDefinition) {
        try {
            return (QueryTemplate)this.queryTemplates.get((Object)((StatementDefinition)statementDefinition).getSql(), () -> this.createQueryTemplate(statementDefinition, connector, connection));
        }
        catch (ExecutionException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not resolve query: " + ((StatementDefinition)statementDefinition).getSql()), (Object[])new Object[]{e}));
        }
    }

    private QueryTemplate resolveQueryTemplate(QueryTemplate queryTemplate, Map<Integer, DbType> paramTypes) {
        ArrayList<QueryParam> newParams = new ArrayList<QueryParam>();
        for (QueryParam originalParam : queryTemplate.getParams()) {
            AbstractQueryParam newParam;
            DbType type = paramTypes.get(originalParam.getIndex());
            if (originalParam instanceof InOutQueryParam) {
                newParam = new DefaultInOutQueryParam(originalParam.getIndex(), type, originalParam.getName(), ((InOutQueryParam)originalParam).getValue());
            } else if (originalParam instanceof InputQueryParam) {
                newParam = new DefaultInputQueryParam(originalParam.getIndex(), type, ((InputQueryParam)originalParam).getValue(), originalParam.getName());
            } else if (originalParam instanceof OutputQueryParam) {
                newParam = new DefaultOutputQueryParam(originalParam.getIndex(), type, originalParam.getName());
            } else {
                throw new IllegalArgumentException("Unknown parameter type: " + originalParam.getClass().getName());
            }
            newParams.add(newParam);
        }
        return new QueryTemplate(queryTemplate.getSqlText(), queryTemplate.getType(), newParams);
    }

    private boolean needsParamTypeResolution(QueryTemplate template) {
        return template.getParams().stream().map(QueryParam::getType).anyMatch(type -> type == UnknownDbType.getInstance() || type instanceof DynamicDbType);
    }

    protected DbTypeManager createTypeManager(DbConnector connector, DbConnection connection) {
        LinkedList<DbTypeManager> typeManagers = new LinkedList<DbTypeManager>();
        typeManagers.add(connector.getTypeManager());
        this.collectTypeManager(typeManagers, connection.getVendorDataTypes());
        this.collectTypeManager(typeManagers, connection.getCustomDataTypes());
        return new CompositeDbTypeManager(typeManagers);
    }

    private void collectTypeManager(List<DbTypeManager> collector, List<DbType> extraDataTypes) {
        if (!CollectionUtils.isEmpty(extraDataTypes)) {
            collector.add(new StaticDbTypeManager(extraDataTypes));
        }
    }
}

