/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.resolver.param;

import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.mule.extension.db.internal.domain.connection.DbConnection;
import org.mule.extension.db.internal.domain.param.QueryParam;
import org.mule.extension.db.internal.domain.query.QueryTemplate;
import org.mule.extension.db.internal.domain.type.DbType;
import org.mule.extension.db.internal.domain.type.DbTypeManager;
import org.mule.extension.db.internal.domain.type.ResolvedDbType;
import org.mule.extension.db.internal.domain.type.UnknownDbType;
import org.mule.extension.db.internal.domain.type.UnknownDbTypeException;
import org.mule.extension.db.internal.resolver.param.ParamTypeResolver;

public class QueryParamTypeResolver
implements ParamTypeResolver {
    private final DbTypeManager dbTypeManager;

    public QueryParamTypeResolver(DbTypeManager dbTypeManager) {
        this.dbTypeManager = dbTypeManager;
    }

    @Override
    public Map<Integer, DbType> getParameterTypes(DbConnection connection, QueryTemplate queryTemplate) throws SQLException {
        HashMap<Integer, DbType> paramTypes = new HashMap<Integer, DbType>();
        PreparedStatement statement = connection.getJdbcConnection().prepareStatement(queryTemplate.getSqlText());
        ParameterMetaData parameterMetaData = statement.getParameterMetaData();
        for (QueryParam queryParam : queryTemplate.getParams()) {
            DbType dbType;
            int parameterTypeId = parameterMetaData.getParameterType(queryParam.getIndex());
            String parameterTypeName = parameterMetaData.getParameterTypeName(queryParam.getIndex());
            if (parameterTypeName == null) {
                dbType = UnknownDbType.getInstance();
            } else {
                try {
                    dbType = this.dbTypeManager.lookup(connection, parameterTypeId, parameterTypeName);
                }
                catch (UnknownDbTypeException e) {
                    dbType = new ResolvedDbType(parameterTypeId, parameterTypeName);
                }
            }
            paramTypes.put(queryParam.getIndex(), dbType);
        }
        return paramTypes;
    }
}

