/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.resolver.param;

import java.util.LinkedList;
import java.util.List;
import org.mule.extension.db.internal.domain.query.QueryParamValue;
import org.mule.extension.db.internal.resolver.param.ParamValueResolver;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.el.ExpressionManager;

public class DynamicParamValueResolver
implements ParamValueResolver {
    private final ExpressionManager expressionManager;

    public DynamicParamValueResolver(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
    }

    @Override
    public List<QueryParamValue> resolveParams(Event muleEvent, List<QueryParamValue> templateParams) {
        LinkedList<QueryParamValue> params = new LinkedList<QueryParamValue>();
        if (templateParams != null) {
            for (QueryParamValue templateParam : templateParams) {
                if (templateParam != null && templateParam.getValue() instanceof String && this.expressionManager.isExpression((String)templateParam.getValue())) {
                    TypedValue newValue = this.expressionManager.evaluate((String)templateParam.getValue(), muleEvent);
                    QueryParamValue queryParamValue = new QueryParamValue(templateParam.getName(), newValue);
                    params.add(queryParamValue);
                    continue;
                }
                params.add(templateParam);
            }
        }
        return params;
    }
}

