/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.operation;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import javax.inject.Inject;
import org.mule.extension.db.api.StatementResult;
import org.mule.extension.db.api.param.QueryDefinition;
import org.mule.extension.db.api.param.StoredProcedureCall;
import org.mule.extension.db.internal.DbConnector;
import org.mule.extension.db.internal.StatementStreamingResultSetCloser;
import org.mule.extension.db.internal.domain.connection.DbConnection;
import org.mule.extension.db.internal.domain.executor.SelectExecutor;
import org.mule.extension.db.internal.domain.executor.StoredProcedureExecutor;
import org.mule.extension.db.internal.domain.metadata.SelectMetadataResolver;
import org.mule.extension.db.internal.domain.metadata.StoredProcedureMetadataResolver;
import org.mule.extension.db.internal.domain.query.Query;
import org.mule.extension.db.internal.domain.query.QueryType;
import org.mule.extension.db.internal.domain.statement.QueryStatementFactory;
import org.mule.extension.db.internal.operation.AutoGeneratedKeyAttributes;
import org.mule.extension.db.internal.operation.BaseDbOperations;
import org.mule.extension.db.internal.operation.StatementAttributes;
import org.mule.extension.db.internal.resolver.query.StoredProcedureQueryResolver;
import org.mule.extension.db.internal.result.resultset.IteratorResultSetHandler;
import org.mule.extension.db.internal.result.resultset.ListResultSetHandler;
import org.mule.extension.db.internal.result.resultset.ResultSetHandler;
import org.mule.extension.db.internal.result.row.InsensitiveMapRowHandler;
import org.mule.extension.db.internal.result.statement.AbstractMapStatementResultHandler;
import org.mule.extension.db.internal.result.statement.EagerStatementResultHandler;
import org.mule.extension.db.internal.result.statement.StreamingStatementResultHandler;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.UseConfig;
import org.mule.runtime.extension.api.runtime.operation.InterceptingCallback;

public class DmlOperations
extends BaseDbOperations {
    @Inject
    private StatementStreamingResultSetCloser resultSetCloser;
    private final StoredProcedureQueryResolver storedProcedureResolver = new StoredProcedureQueryResolver();

    @OutputResolver(output=SelectMetadataResolver.class)
    public InterceptingCallback<Object> select(@ParameterGroup(value="Query") QueryDefinition query, @Optional(defaultValue="false") @Expression(value=ExpressionSupport.NOT_SUPPORTED) boolean streaming, @ParameterGroup(value="Query Settings") StatementAttributes statementAttributes, @UseConfig DbConnector connector, @Connection DbConnection connection) throws SQLException {
        Query resolvedQuery = this.resolveQuery(query, connector, connection, QueryType.SELECT, QueryType.STORE_PROCEDURE_CALL);
        QueryStatementFactory statementFactory = this.getStatementFactory(statementAttributes, streaming, query);
        InsensitiveMapRowHandler recordHandler = new InsensitiveMapRowHandler();
        ResultSetHandler resultSetHandler = streaming ? new IteratorResultSetHandler(recordHandler, this.resultSetCloser) : new ListResultSetHandler(recordHandler);
        Object result = new SelectExecutor(statementFactory, resultSetHandler).execute(connection, resolvedQuery);
        return this.interceptingCallback(result, connection);
    }

    public StatementResult insert(@ParameterGroup(value="Query") QueryDefinition query, @ParameterGroup(value="Auto Generated Keys") AutoGeneratedKeyAttributes autoGeneratedKeyAttributes, @UseConfig DbConnector connector, @Connection DbConnection connection) throws SQLException {
        Query resolvedQuery = this.resolveQuery(query, connector, connection, QueryType.INSERT);
        return this.executeUpdate(query, null, autoGeneratedKeyAttributes, connection, resolvedQuery);
    }

    public StatementResult update(@ParameterGroup(value="Query") QueryDefinition query, @ParameterGroup(value="Auto Generated Keys") AutoGeneratedKeyAttributes autoGeneratedKeyAttributes, @UseConfig DbConnector connector, @Connection DbConnection connection) throws SQLException {
        Query resolvedQuery = this.resolveQuery(query, connector, connection, QueryType.UPDATE, QueryType.TRUNCATE, QueryType.MERGE, QueryType.STORE_PROCEDURE_CALL);
        return this.executeUpdate(query, null, autoGeneratedKeyAttributes, connection, resolvedQuery);
    }

    public int delete(@ParameterGroup(value="Query") QueryDefinition query, @UseConfig DbConnector connector, @Connection DbConnection connection) throws SQLException {
        Query resolvedQuery = this.resolveQuery(query, connector, connection, QueryType.DELETE);
        return this.executeUpdate(query, null, null, connection, resolvedQuery).getAffectedRows();
    }

    @OutputResolver(output=StoredProcedureMetadataResolver.class)
    public InterceptingCallback<Map<String, Object>> storedProcedure(@ParameterGroup(value="Query") StoredProcedureCall call, @Optional(defaultValue="false") @Expression(value=ExpressionSupport.NOT_SUPPORTED) boolean streaming, @ParameterGroup(value="Query Settings") StatementAttributes statementAttributes, @ParameterGroup(value="Auto Generated Keys") AutoGeneratedKeyAttributes autoGeneratedKeyAttributes, @UseConfig DbConnector connector, @Connection DbConnection connection) throws SQLException {
        Query resolvedQuery = this.resolveQuery(call, connector, connection, QueryType.STORE_PROCEDURE_CALL);
        QueryStatementFactory statementFactory = this.getStatementFactory(statementAttributes, streaming, call);
        InsensitiveMapRowHandler recordHandler = new InsensitiveMapRowHandler();
        AbstractMapStatementResultHandler resultHandler = streaming ? new StreamingStatementResultHandler(new IteratorResultSetHandler(recordHandler, this.resultSetCloser)) : new EagerStatementResultHandler(new ListResultSetHandler(recordHandler));
        Map result = (Map)new StoredProcedureExecutor(statementFactory, resultHandler).execute(connection, resolvedQuery, this.getAutoGeneratedKeysStrategy(autoGeneratedKeyAttributes));
        return this.interceptingCallback(result, connection);
    }

    private <T> InterceptingCallback<T> interceptingCallback(final T result, final DbConnection connection) {
        return new InterceptingCallback<T>(){

            public T getResult() throws Exception {
                return result;
            }

            public void onException(Exception exception) {
                DmlOperations.this.resultSetCloser.closeResultSets(connection);
            }
        };
    }

    protected Query resolveQuery(StoredProcedureCall call, DbConnector connector, DbConnection connection, QueryType ... validTypes) {
        Query resolvedQuery = this.storedProcedureResolver.resolve(call, connector, connection);
        this.validateQueryType(resolvedQuery.getQueryTemplate(), Arrays.asList(validTypes));
        return resolvedQuery;
    }
}

