/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.operation;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.mule.extension.db.api.param.BulkQueryDefinition;
import org.mule.extension.db.api.param.BulkScript;
import org.mule.extension.db.api.param.QuerySettings;
import org.mule.extension.db.internal.DbConnector;
import org.mule.extension.db.internal.domain.connection.DbConnection;
import org.mule.extension.db.internal.domain.executor.BulkUpdateExecutor;
import org.mule.extension.db.internal.domain.query.BulkQuery;
import org.mule.extension.db.internal.domain.query.Query;
import org.mule.extension.db.internal.domain.query.QueryParamValue;
import org.mule.extension.db.internal.domain.query.QueryType;
import org.mule.extension.db.internal.operation.BaseDbOperations;
import org.mule.extension.db.internal.parser.SimpleQueryTemplateParser;
import org.mule.extension.db.internal.resolver.query.BulkQueryFactory;
import org.mule.extension.db.internal.resolver.query.BulkQueryResolver;
import org.mule.extension.db.internal.resolver.query.DefaultBulkQueryFactory;
import org.mule.extension.db.internal.resolver.query.FileBulkQueryFactory;
import org.mule.extension.db.internal.util.DefaultFileReader;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.UseConfig;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

public class BulkOperations
extends BaseDbOperations {
    private BulkQueryResolver bulkQueryResolver = new BulkQueryResolver();

    public int[] bulkInsert(@Content @Placement(order=1) List<Map<String, Object>> parameterValues, @ParameterGroup(value="Query") BulkQueryDefinition query, @UseConfig DbConnector connector, @Connection DbConnection connection) throws SQLException {
        return this.singleQueryBulk(query, parameterValues, QueryType.INSERT, connector, connection);
    }

    public int[] bulkUpdate(@Content @Placement(order=1) List<Map<String, Object>> parameterValues, @ParameterGroup(value="Query") BulkQueryDefinition query, @UseConfig DbConnector connector, @Connection DbConnection connection) throws SQLException {
        return this.singleQueryBulk(query, parameterValues, QueryType.UPDATE, connector, connection);
    }

    public int[] bulkDelete(@Content @Placement(order=1) List<Map<String, Object>> parameterValues, @ParameterGroup(value="Query") BulkQueryDefinition query, @UseConfig DbConnector connector, @Connection DbConnection connection) throws SQLException {
        return this.singleQueryBulk(query, parameterValues, QueryType.DELETE, connector, connection);
    }

    public int[] executeScript(@ParameterGroup(value="Query") BulkScript script, @ParameterGroup(value="Query Settings") QuerySettings settings, @Connection DbConnection connection) throws SQLException {
        SimpleQueryTemplateParser queryParser = new SimpleQueryTemplateParser();
        BulkQueryFactory bulkQueryFactory = !StringUtils.isEmpty((String)script.getFile()) ? new FileBulkQueryFactory(script.getFile(), queryParser, new DefaultFileReader()) : new DefaultBulkQueryFactory(queryParser, script.getSql());
        BulkQuery bulkQuery = bulkQueryFactory.resolve();
        BulkUpdateExecutor bulkUpdateExecutor = new BulkUpdateExecutor(this.getStatementFactory(null, false, settings));
        return (int[])bulkUpdateExecutor.execute(connection, bulkQuery);
    }

    private int[] singleQueryBulk(BulkQueryDefinition query, List<Map<String, Object>> values, QueryType queryType, DbConnector connector, DbConnection connection) throws SQLException {
        Query resolvedQuery = this.resolveQuery(query, connector, connection, queryType);
        List<List<QueryParamValue>> paramSets = this.resolveParamSets(values);
        BulkUpdateExecutor bulkUpdateExecutor = new BulkUpdateExecutor(this.getStatementFactory(null, false, query));
        return (int[])bulkUpdateExecutor.execute(connection, resolvedQuery, paramSets);
    }

    private Query resolveQuery(BulkQueryDefinition query, DbConnector connector, DbConnection connection, QueryType ... validTypes) {
        Query resolvedQuery = this.bulkQueryResolver.resolve(query, connector, connection);
        this.validateQueryType(resolvedQuery.getQueryTemplate(), Arrays.asList(validTypes));
        this.validateNoParameterTypeIsUnused(resolvedQuery, query.getParameterTypes());
        return resolvedQuery;
    }

    private List<List<QueryParamValue>> resolveParamSets(List<Map<String, Object>> values) {
        return values.stream().map(map -> map.entrySet().stream().map(entry -> new QueryParamValue((String)entry.getKey(), entry.getValue())).collect(Collectors.toList())).collect(Collectors.toList());
    }
}

