/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.operation;

import com.google.common.base.Joiner;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.mule.extension.db.api.StatementResult;
import org.mule.extension.db.api.param.ParameterType;
import org.mule.extension.db.api.param.ParameterizedStatementDefinition;
import org.mule.extension.db.api.param.QueryDefinition;
import org.mule.extension.db.api.param.QuerySettings;
import org.mule.extension.db.internal.DbConnector;
import org.mule.extension.db.internal.domain.autogeneratedkey.AutoGeneratedKeyStrategy;
import org.mule.extension.db.internal.domain.autogeneratedkey.ColumnIndexAutoGeneratedKeyStrategy;
import org.mule.extension.db.internal.domain.autogeneratedkey.ColumnNameAutoGeneratedKeyStrategy;
import org.mule.extension.db.internal.domain.autogeneratedkey.DefaultAutoGeneratedKeyStrategy;
import org.mule.extension.db.internal.domain.autogeneratedkey.NoAutoGeneratedKeyStrategy;
import org.mule.extension.db.internal.domain.connection.DbConnection;
import org.mule.extension.db.internal.domain.executor.UpdateExecutor;
import org.mule.extension.db.internal.domain.param.QueryParam;
import org.mule.extension.db.internal.domain.query.Query;
import org.mule.extension.db.internal.domain.query.QueryTemplate;
import org.mule.extension.db.internal.domain.query.QueryType;
import org.mule.extension.db.internal.domain.statement.QueryStatementFactory;
import org.mule.extension.db.internal.operation.AutoGeneratedKeyAttributes;
import org.mule.extension.db.internal.operation.DmlOperations;
import org.mule.extension.db.internal.operation.StatementAttributes;
import org.mule.extension.db.internal.resolver.query.ParameterizedQueryResolver;
import org.mule.extension.db.internal.resolver.query.QueryResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseDbOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(DmlOperations.class);
    protected static final int DEFAULT_FETCH_SIZE = 10;
    protected static final String QUERY_GROUP = "Query";
    protected static final String QUERY_SETTINGS = "Query Settings";
    protected final QueryResolver<ParameterizedStatementDefinition> queryResolver = new ParameterizedQueryResolver<ParameterizedStatementDefinition>();

    BaseDbOperations() {
    }

    protected QueryStatementFactory getStatementFactory(StatementAttributes statementAttributes, boolean streaming, QuerySettings settings) {
        QueryStatementFactory statementFactory = new QueryStatementFactory();
        if (statementAttributes != null) {
            if (statementAttributes.getMaxRows() != null) {
                statementFactory.setMaxRows(statementAttributes.getMaxRows());
            }
            if (statementAttributes.getFetchSize() != null) {
                statementFactory.setFetchSize(statementAttributes.getFetchSize());
            } else if (streaming) {
                LOGGER.warn("Streaming mode needs to configure fetchSize property. Using default value: 10");
                statementFactory.setFetchSize(10);
            }
        }
        statementFactory.setQueryTimeout(new Long(settings.getQueryTimeoutUnit().toSeconds(settings.getQueryTimeout())).intValue());
        return statementFactory;
    }

    protected StatementResult executeUpdate(QueryDefinition query, StatementAttributes statementAttributes, AutoGeneratedKeyAttributes autoGeneratedKeyAttributes, DbConnection connection, Query resolvedQuery) throws SQLException {
        QueryStatementFactory statementFactory = this.getStatementFactory(statementAttributes, false, query);
        return (StatementResult)new UpdateExecutor(statementFactory).execute(connection, resolvedQuery, this.getAutoGeneratedKeysStrategy(autoGeneratedKeyAttributes));
    }

    protected Query resolveQuery(QueryDefinition query, DbConnector connector, DbConnection connection, QueryType ... validTypes) {
        Query resolvedQuery = this.queryResolver.resolve(query, connector, connection);
        this.validateQueryType(resolvedQuery.getQueryTemplate(), Arrays.asList(validTypes));
        this.validateNoParameterTypeIsUnused(resolvedQuery, query.getParameterTypes());
        return resolvedQuery;
    }

    protected void validateQueryType(QueryTemplate queryTemplate, List<QueryType> validTypes) {
        if (validTypes == null || !validTypes.contains((Object)queryTemplate.getType())) {
            throw new IllegalArgumentException(String.format("Query type must be one of [%s] but query '%s' is of type '%s'", new Object[]{Joiner.on((String)", ").join(validTypes), queryTemplate.getSqlText(), queryTemplate.getType()}));
        }
    }

    protected void validateNoParameterTypeIsUnused(Query query, List<ParameterType> parameterTypes) {
        Set params = query.getQueryTemplate().getParams().stream().map(QueryParam::getName).collect(Collectors.toSet());
        Set unusedTypes = parameterTypes.stream().map(type -> type.getKey()).filter(type -> !params.contains(type)).collect(Collectors.toSet());
        if (!unusedTypes.isEmpty()) {
            throw new IllegalArgumentException(String.format("Query defines parameters [%s] but they aren't present in the query", Joiner.on((String)", ").join((Iterable)unusedTypes.stream().map(s -> "'" + s + "'").collect(Collectors.toList()))));
        }
    }

    protected AutoGeneratedKeyStrategy getAutoGeneratedKeysStrategy(AutoGeneratedKeyAttributes keyAttributes) {
        if (keyAttributes == null) {
            return new NoAutoGeneratedKeyStrategy();
        }
        if (keyAttributes.isAutoGeneratedKeys()) {
            List<Integer> columnIndexes = keyAttributes.getAutoGeneratedKeysColumnIndexes();
            List<String> columnNames = keyAttributes.getAutoGeneratedKeysColumnNames();
            if (!CollectionUtils.isEmpty(columnIndexes)) {
                int[] indexes = new int[columnIndexes.size()];
                int i = 0;
                for (int index : columnIndexes) {
                    indexes[i++] = index;
                }
                return new ColumnIndexAutoGeneratedKeyStrategy(indexes);
            }
            if (!CollectionUtils.isEmpty(columnNames)) {
                return new ColumnNameAutoGeneratedKeyStrategy((String[])columnNames.stream().toArray(String[]::new));
            }
            return new DefaultAutoGeneratedKeyStrategy();
        }
        return new NoAutoGeneratedKeyStrategy();
    }
}

