/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.domain.xa;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.mule.extension.db.internal.domain.connection.DbConnection;
import org.mule.extension.db.internal.domain.type.DbType;
import org.mule.extension.db.internal.result.resultset.ResultSetHandler;
import org.mule.extension.db.internal.result.statement.StatementResultIteratorFactory;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.transaction.TransactionException;
import org.mule.runtime.extension.api.connectivity.XATransactionalConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XADbConnection
implements DbConnection,
XATransactionalConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(XADbConnection.class);
    private final DbConnection connection;
    private final XAConnection xaResource;

    public XADbConnection(DbConnection connection, XAConnection xaResource) {
        this.connection = connection;
        this.xaResource = xaResource;
    }

    public XAResource getXAResource() {
        try {
            return this.xaResource.getXAResource();
        }
        catch (SQLException e) {
            throw new MuleRuntimeException((Throwable)new TransactionException(I18nMessageFactory.createStaticMessage((String)"Could not obtain XA Resource"), (Throwable)e));
        }
    }

    public void close() {
        this.connection.release();
        try {
            this.xaResource.close();
        }
        catch (SQLException e) {
            LOGGER.info("Exception while explicitly closing the xaConnection (some providers require this). The exception will be ignored and only logged: " + e.getMessage(), (Throwable)e);
        }
    }

    public void begin() throws Exception {
        this.connection.begin();
    }

    public void commit() throws Exception {
        this.connection.commit();
    }

    public void rollback() throws Exception {
        this.connection.rollback();
    }

    @Override
    public StatementResultIteratorFactory getStatementResultIteratorFactory(ResultSetHandler resultSetHandler) {
        return this.connection.getStatementResultIteratorFactory(resultSetHandler);
    }

    @Override
    public List<DbType> getVendorDataTypes() {
        return this.connection.getVendorDataTypes();
    }

    @Override
    public List<DbType> getCustomDataTypes() {
        return this.connection.getCustomDataTypes();
    }

    @Override
    public Connection getJdbcConnection() {
        return this.connection.getJdbcConnection();
    }

    @Override
    public void release() {
        this.connection.release();
    }

    @Override
    public void beginStreaming() {
        this.connection.beginStreaming();
    }

    @Override
    public boolean isStreaming() {
        return this.connection.isStreaming();
    }

    @Override
    public void endStreaming() {
        this.connection.endStreaming();
    }
}

