/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.domain.type;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.io.IOUtils;
import org.mule.extension.db.internal.domain.type.ResolvedDbType;

public class ClobResolvedDataType
extends ResolvedDbType {
    public ClobResolvedDataType(int id, String name) {
        super(id, name);
    }

    @Override
    public void setParameterValue(PreparedStatement statement, int index, Object value) throws SQLException {
        if (value != null && !(value instanceof Clob)) {
            Clob clob = statement.getConnection().createClob();
            if (value instanceof String) {
                clob.setString(1L, (String)value);
            } else if (value instanceof InputStream) {
                try {
                    clob.setString(1L, IOUtils.toString((InputStream)((InputStream)value)));
                }
                catch (IOException e) {
                    throw new SQLException(e);
                }
            } else {
                throw new IllegalArgumentException(ClobResolvedDataType.createUnsupportedTypeErrorMessage(value));
            }
            value = clob;
        }
        super.setParameterValue(statement, index, value);
    }

    protected static String createUnsupportedTypeErrorMessage(Object value) {
        return String.format("Cannot create a Clob from a value of type '%s'", value.getClass());
    }
}

