/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.domain.type;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.io.IOUtils;
import org.mule.extension.db.internal.domain.type.ResolvedDbType;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;

public class BlobDbType
extends ResolvedDbType {
    public BlobDbType(int id, String name) {
        super(id, name);
    }

    @Override
    public void setParameterValue(PreparedStatement statement, int index, Object value) throws SQLException {
        if (value instanceof byte[]) {
            Blob blob = statement.getConnection().createBlob();
            blob.setBytes(1L, (byte[])value);
            value = blob;
        } else if (value instanceof InputStream) {
            try {
                Blob blob = statement.getConnection().createBlob();
                blob.setBytes(1L, IOUtils.toByteArray((InputStream)((InputStream)value)));
                value = blob;
            }
            catch (IOException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not consume inputStream in parameter of index " + index)), (Throwable)e);
            }
        }
        super.setParameterValue(statement, index, value);
    }
}

