/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.domain.query;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.Validate;
import org.mule.extension.db.internal.domain.param.InputQueryParam;
import org.mule.extension.db.internal.domain.param.OutputQueryParam;
import org.mule.extension.db.internal.domain.param.QueryParam;
import org.mule.extension.db.internal.domain.query.QueryType;
import org.mule.runtime.core.util.StringUtils;

public class QueryTemplate {
    private final String sqlText;
    private final List<InputQueryParam> inputParams;
    private final List<OutputQueryParam> outputParams;
    private final List<QueryParam> params;
    private final QueryType type;
    private final boolean dynamic;
    private final boolean namedParams;

    public QueryTemplate(String sqlText, QueryType type, List<QueryParam> params) {
        this(sqlText, type, params, false);
    }

    public QueryTemplate(String sqlText, QueryType type, List<QueryParam> params, boolean dynamic) {
        Validate.notEmpty((String)sqlText);
        this.sqlText = sqlText;
        Validate.notNull((Object)((Object)type));
        this.type = type;
        this.inputParams = this.filter(params, InputQueryParam.class);
        this.outputParams = this.filter(params, OutputQueryParam.class);
        this.params = params;
        this.dynamic = dynamic;
        this.namedParams = this.usesNamedParams();
    }

    public QueryTemplate(QueryTemplate source) {
        this.sqlText = source.sqlText;
        this.type = source.type;
        this.inputParams = source.inputParams;
        this.outputParams = source.outputParams;
        this.params = source.params;
        this.dynamic = source.dynamic;
        this.namedParams = source.namedParams;
    }

    private boolean usesNamedParams() {
        boolean firstParam = true;
        boolean namedParams = false;
        for (InputQueryParam inputParam : this.inputParams) {
            if (firstParam) {
                namedParams = !StringUtils.isEmpty((String)inputParam.getName());
                firstParam = false;
                continue;
            }
            if (namedParams != StringUtils.isEmpty((String)inputParam.getName())) continue;
            throw new IllegalArgumentException("Cannot mix named and inline parameters in the same query");
        }
        return namedParams;
    }

    private <T extends QueryParam> List<T> filter(List<QueryParam> params, Class<T> filterType) {
        return params.stream().filter(filterType::isInstance).map(param -> param).collect(Collectors.toCollection(LinkedList::new));
    }

    public String getSqlText() {
        return this.sqlText;
    }

    public List<InputQueryParam> getInputParams() {
        return this.inputParams;
    }

    public List<OutputQueryParam> getOutputParams() {
        return this.outputParams;
    }

    public List<QueryParam> getParams() {
        return this.params;
    }

    public QueryType getType() {
        return this.type;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public boolean usesNamedParameters() {
        return this.namedParams;
    }
}

