/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.domain.query;

import java.util.List;
import java.util.stream.Collectors;
import org.mule.extension.db.internal.domain.query.QueryParamValue;
import org.mule.extension.db.internal.domain.query.QueryTemplate;

public class Query {
    private final QueryTemplate queryTemplate;
    private final List<QueryParamValue> paramValues;

    public Query(QueryTemplate queryTemplate, List<QueryParamValue> paramValues) {
        this.paramValues = paramValues;
        this.queryTemplate = queryTemplate;
    }

    public Query(QueryTemplate queryTemplate) {
        this.queryTemplate = queryTemplate;
        this.paramValues = queryTemplate.getInputParams().stream().map(p -> new QueryParamValue(p.getName(), p.getValue())).collect(Collectors.toList());
    }

    public QueryTemplate getQueryTemplate() {
        return this.queryTemplate;
    }

    public List<QueryParamValue> getParamValues() {
        return this.paramValues;
    }

    public boolean isDynamic() {
        return this.queryTemplate.isDynamic();
    }
}

