/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.domain.metadata;

import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.mule.extension.db.internal.domain.metadata.BaseDbMetadataResolver;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;

public class SelectMetadataResolver
extends BaseDbMetadataResolver
implements OutputTypeResolver<String> {
    public static final String DUPLICATE_COLUMN_LABEL_ERROR = "Query metadata contains multiple columns with the same label. Define column aliases to resolve this problem";

    public String getCategoryName() {
        return "DbCategory";
    }

    public MetadataType getOutputType(MetadataContext context, String query) throws MetadataResolvingException, ConnectionException {
        ResultSetMetaData statementMetaData;
        this.typeLoader = context.getTypeLoader();
        this.typeBuilder = context.getTypeBuilder();
        if (StringUtils.isEmpty((String)query)) {
            throw new MetadataResolvingException("No Metadata available for an empty query", FailureCode.INVALID_METADATA_KEY);
        }
        PreparedStatement statement = this.getStatement(context, this.parseQuery(query));
        try {
            statementMetaData = statement.getMetaData();
        }
        catch (SQLException e2) {
            throw new MetadataResolvingException(e2.getMessage(), FailureCode.UNKNOWN, (Throwable)e2);
        }
        if (statementMetaData == null) {
            throw new MetadataResolvingException(String.format("Driver did not return metadata for the provided SQL: [%s]", query), FailureCode.INVALID_METADATA_KEY);
        }
        HashMap<String, MetadataType> recordModels = new HashMap<String, MetadataType>();
        try {
            for (int i = 1; i <= statementMetaData.getColumnCount(); ++i) {
                int columnType = statementMetaData.getColumnType(i);
                recordModels.put(statementMetaData.getColumnLabel(i), this.getDataTypeMetadataModel(columnType, statementMetaData.getColumnClassName(i)));
            }
            if (statementMetaData.getColumnCount() != recordModels.size()) {
                throw new MetadataResolvingException(DUPLICATE_COLUMN_LABEL_ERROR, FailureCode.INVALID_METADATA_KEY);
            }
        }
        catch (SQLException e3) {
            throw new MetadataResolvingException(e3.getMessage(), FailureCode.UNKNOWN, (Throwable)e3);
        }
        ObjectTypeBuilder record = this.typeBuilder.objectType().id("recordModel");
        recordModels.entrySet().forEach(e -> record.addField().key((String)e.getKey()).value((MetadataType)e.getValue()));
        return this.typeBuilder.arrayType().of((TypeBuilder)record).build();
    }
}

