/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.domain.metadata;

import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.mule.extension.db.internal.domain.connection.DbConnection;
import org.mule.extension.db.internal.domain.query.QueryTemplate;
import org.mule.extension.db.internal.parser.SimpleQueryTemplateParser;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;

public abstract class BaseDbMetadataResolver {
    protected BaseTypeBuilder typeBuilder;
    protected ClassTypeLoader typeLoader;
    private Map<Integer, MetadataType> dbToMetaDataType;

    protected QueryTemplate parseQuery(String query) {
        return new SimpleQueryTemplateParser().parse(query);
    }

    protected PreparedStatement getStatement(MetadataContext context, QueryTemplate query) throws ConnectionException, MetadataResolvingException {
        PreparedStatement statement;
        DbConnection connection = (DbConnection)context.getConnection().orElseThrow(() -> new MetadataResolvingException("A connection is required to resolve Metadata but none was provided", FailureCode.INVALID_CONFIGURATION));
        try {
            statement = connection.getJdbcConnection().prepareStatement(query.getSqlText());
        }
        catch (SQLException e) {
            throw new MetadataResolvingException(e.getMessage(), FailureCode.UNKNOWN, (Throwable)e);
        }
        return statement;
    }

    protected MetadataType getDataTypeMetadataModel(int columnTypeName, String columnClassName) {
        if (columnTypeName == 2000) {
            return (MetadataType)this.typeLoader.load(columnClassName).orElse(this.typeBuilder.anyType().build());
        }
        return this.getDataTypeMetadataModel(columnTypeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MetadataType getDataTypeMetadataModel(int columnTypeName) {
        if (this.dbToMetaDataType == null) {
            BaseDbMetadataResolver baseDbMetadataResolver = this;
            synchronized (baseDbMetadataResolver) {
                if (this.dbToMetaDataType == null) {
                    this.initializeDbToMetaDataType();
                }
            }
        }
        return this.dbToMetaDataType.getOrDefault(columnTypeName, (MetadataType)this.typeBuilder.anyType().build());
    }

    private void initializeDbToMetaDataType() {
        this.dbToMetaDataType = new HashMap<Integer, MetadataType>();
        this.dbToMetaDataType.put(-7, (MetadataType)this.typeBuilder.booleanType().build());
        this.dbToMetaDataType.put(-6, (MetadataType)this.typeBuilder.binaryType().build());
        this.dbToMetaDataType.put(5, (MetadataType)this.typeBuilder.numberType().build());
        this.dbToMetaDataType.put(4, (MetadataType)this.typeBuilder.numberType().build());
        this.dbToMetaDataType.put(-5, (MetadataType)this.typeBuilder.numberType().build());
        this.dbToMetaDataType.put(6, (MetadataType)this.typeBuilder.numberType().build());
        this.dbToMetaDataType.put(7, (MetadataType)this.typeBuilder.numberType().build());
        this.dbToMetaDataType.put(8, (MetadataType)this.typeBuilder.numberType().build());
        this.dbToMetaDataType.put(2, (MetadataType)this.typeBuilder.numberType().build());
        this.dbToMetaDataType.put(3, (MetadataType)this.typeBuilder.numberType().build());
        this.dbToMetaDataType.put(1, (MetadataType)this.typeBuilder.stringType().build());
        this.dbToMetaDataType.put(12, (MetadataType)this.typeBuilder.stringType().build());
        this.dbToMetaDataType.put(-16, (MetadataType)this.typeBuilder.stringType().build());
        this.dbToMetaDataType.put(91, this.typeLoader.load(Date.class));
        this.dbToMetaDataType.put(92, this.typeLoader.load(Time.class));
        this.dbToMetaDataType.put(93, this.typeLoader.load(Timestamp.class));
        this.dbToMetaDataType.put(-2, (MetadataType)this.typeBuilder.binaryType().build());
        this.dbToMetaDataType.put(-3, (MetadataType)this.typeBuilder.binaryType().build());
        this.dbToMetaDataType.put(-4, (MetadataType)this.typeBuilder.binaryType().build());
        this.dbToMetaDataType.put(0, (MetadataType)this.typeBuilder.nullType().build());
        this.dbToMetaDataType.put(1111, (MetadataType)this.typeBuilder.anyType().build());
        this.dbToMetaDataType.put(2001, (MetadataType)this.typeBuilder.anyType().build());
        this.dbToMetaDataType.put(2002, this.typeLoader.load(Struct.class));
        this.dbToMetaDataType.put(2003, (MetadataType)this.typeBuilder.arrayType().of().anyType().build());
        this.dbToMetaDataType.put(2004, this.typeLoader.load(Blob.class));
        this.dbToMetaDataType.put(2005, this.typeLoader.load(Clob.class));
        this.dbToMetaDataType.put(2006, this.typeLoader.load(Ref.class));
        this.dbToMetaDataType.put(70, this.typeLoader.load(URL.class));
        this.dbToMetaDataType.put(16, (MetadataType)this.typeBuilder.booleanType().build());
        this.dbToMetaDataType.put(-8, this.typeLoader.load(RowId.class));
        this.dbToMetaDataType.put(-15, (MetadataType)this.typeBuilder.stringType().build());
        this.dbToMetaDataType.put(-9, (MetadataType)this.typeBuilder.stringType().build());
        this.dbToMetaDataType.put(-16, (MetadataType)this.typeBuilder.stringType().build());
        this.dbToMetaDataType.put(2011, (MetadataType)this.typeBuilder.stringType().build());
        this.dbToMetaDataType.put(2009, this.typeLoader.load(SQLXML.class));
    }
}

