/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.domain.logger;

import org.mule.extension.db.internal.domain.logger.BulkQueryLogger;
import org.mule.extension.db.internal.domain.logger.DebugBulkQueryLogger;
import org.mule.extension.db.internal.domain.logger.DebugPreparedBulkQueryLogger;
import org.mule.extension.db.internal.domain.logger.DebugSingleQueryLogger;
import org.mule.extension.db.internal.domain.logger.NullBulkQueryLogger;
import org.mule.extension.db.internal.domain.logger.NullPreparedBulkQueryLogger;
import org.mule.extension.db.internal.domain.logger.NullSingleQueryLogger;
import org.mule.extension.db.internal.domain.logger.PreparedBulkQueryLogger;
import org.mule.extension.db.internal.domain.logger.QueryLoggerFactory;
import org.mule.extension.db.internal.domain.logger.SingleQueryLogger;
import org.mule.extension.db.internal.domain.query.QueryTemplate;
import org.slf4j.Logger;

public class DefaultQueryLoggerFactory
implements QueryLoggerFactory {
    @Override
    public SingleQueryLogger createQueryLogger(Logger logger, QueryTemplate queryTemplate) {
        if (logger.isDebugEnabled()) {
            return new DebugSingleQueryLogger(logger, queryTemplate);
        }
        return new NullSingleQueryLogger();
    }

    @Override
    public PreparedBulkQueryLogger createBulkQueryLogger(Logger logger, QueryTemplate queryTemplate, int bulkSize) {
        if (logger.isDebugEnabled()) {
            return new DebugPreparedBulkQueryLogger(logger, queryTemplate, bulkSize);
        }
        return new NullPreparedBulkQueryLogger();
    }

    @Override
    public BulkQueryLogger createBulkQueryLogger(Logger logger) {
        if (logger.isDebugEnabled()) {
            return new DebugBulkQueryLogger(logger);
        }
        return new NullBulkQueryLogger();
    }
}

