/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.domain.logger;

import org.mule.extension.db.internal.domain.logger.AbstractDebugQueryLogger;
import org.mule.extension.db.internal.domain.logger.SingleQueryLogger;
import org.mule.extension.db.internal.domain.param.InputQueryParam;
import org.mule.extension.db.internal.domain.query.QueryTemplate;
import org.slf4j.Logger;

public class DebugSingleQueryLogger
extends AbstractDebugQueryLogger
implements SingleQueryLogger {
    private final QueryTemplate queryTemplate;

    public DebugSingleQueryLogger(Logger logger, QueryTemplate queryTemplate) {
        super(logger);
        this.queryTemplate = queryTemplate;
        this.builder.append("Executing query:\n").append(queryTemplate.getSqlText());
        if (this.hasParameters()) {
            this.builder.append("\nParameters:");
        }
    }

    protected boolean hasParameters() {
        return this.queryTemplate.getInputParams().size() > 0;
    }

    @Override
    public void addParameter(InputQueryParam param, Object value) {
        this.builder.append("\n").append(param.getName() != null ? param.getName() : Integer.valueOf(param.getIndex())).append(" = ").append(value);
    }
}

