/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.domain.executor;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.mule.extension.db.api.StatementResult;
import org.mule.extension.db.internal.domain.autogeneratedkey.AutoGeneratedKeyStrategy;
import org.mule.extension.db.internal.domain.autogeneratedkey.NoAutoGeneratedKeyStrategy;
import org.mule.extension.db.internal.domain.connection.DbConnection;
import org.mule.extension.db.internal.domain.executor.AbstractSingleQueryExecutor;
import org.mule.extension.db.internal.domain.query.Query;
import org.mule.extension.db.internal.domain.statement.StatementFactory;
import org.mule.extension.db.internal.result.resultset.ListResultSetHandler;
import org.mule.extension.db.internal.result.row.InsensitiveMapRowHandler;

public class UpdateExecutor
extends AbstractSingleQueryExecutor {
    public UpdateExecutor(StatementFactory statementFactory) {
        super(statementFactory);
    }

    @Override
    protected Object doExecuteQuery(DbConnection connection, Statement statement, Query query) throws SQLException {
        return this.doExecuteQuery(connection, statement, query, new NoAutoGeneratedKeyStrategy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object doExecuteQuery(DbConnection dbConnection, Statement statement, Query query, AutoGeneratedKeyStrategy autoGeneratedKeyStrategy) throws SQLException {
        try {
            StatementResult result;
            int updateCount = autoGeneratedKeyStrategy.executeUpdate(statement, query.getQueryTemplate());
            if (autoGeneratedKeyStrategy.returnsAutoGeneratedKeys()) {
                ListResultSetHandler listResultSetHandler = new ListResultSetHandler(new InsensitiveMapRowHandler());
                ResultSet generatedKeys = statement.getGeneratedKeys();
                Object generatedKeyList = listResultSetHandler.processResultSet(dbConnection, generatedKeys);
                Map keyMap = generatedKeyList.isEmpty() ? null : (Map)generatedKeyList.get(0);
                result = new StatementResult(updateCount, keyMap);
            } else {
                result = new StatementResult(updateCount, null);
            }
            StatementResult statementResult = result;
            return statementResult;
        }
        finally {
            statement.close();
        }
    }
}

