/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.domain.executor;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.mule.extension.db.internal.domain.connection.DbConnection;
import org.mule.extension.db.internal.domain.executor.AbstractExecutor;
import org.mule.extension.db.internal.domain.executor.BulkExecutor;
import org.mule.extension.db.internal.domain.logger.BulkQueryLogger;
import org.mule.extension.db.internal.domain.logger.PreparedBulkQueryLogger;
import org.mule.extension.db.internal.domain.query.BulkQuery;
import org.mule.extension.db.internal.domain.query.Query;
import org.mule.extension.db.internal.domain.query.QueryParamValue;
import org.mule.extension.db.internal.domain.query.QueryTemplate;
import org.mule.extension.db.internal.domain.statement.StatementFactory;

public class BulkUpdateExecutor
extends AbstractExecutor
implements BulkExecutor {
    public BulkUpdateExecutor(StatementFactory statementFactory) {
        super(statementFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(DbConnection connection, BulkQuery bulkQuery) throws SQLException {
        Statement statement = this.statementFactory.create(connection, bulkQuery.getQueryTemplates().get(0));
        try {
            BulkQueryLogger queryLogger = this.queryLoggerFactory.createBulkQueryLogger(LOGGER);
            for (QueryTemplate queryTemplate : bulkQuery.getQueryTemplates()) {
                String sql = queryTemplate.getSqlText();
                statement.addBatch(sql);
                queryLogger.addQuery(sql);
            }
            queryLogger.logQuery();
            Object object = statement.executeBatch();
            return object;
        }
        finally {
            statement.clearBatch();
            statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(DbConnection connection, Query query, List<List<QueryParamValue>> paramValues) throws SQLException {
        Statement statement = this.statementFactory.create(connection, query.getQueryTemplate());
        if (!(statement instanceof PreparedStatement)) {
            throw new IllegalArgumentException("Bulk update must be executed on a prepared statement");
        }
        PreparedStatement preparedStatement = (PreparedStatement)statement;
        PreparedBulkQueryLogger queryLogger = this.queryLoggerFactory.createBulkQueryLogger(LOGGER, query.getQueryTemplate(), paramValues.size());
        try {
            for (List<QueryParamValue> params : paramValues) {
                this.doProcessParameters(preparedStatement, query.getQueryTemplate(), params, queryLogger);
                preparedStatement.addBatch();
                queryLogger.addParameterSet();
            }
            queryLogger.logQuery();
            Object object = preparedStatement.executeBatch();
            return object;
        }
        finally {
            preparedStatement.clearParameters();
            statement.close();
        }
    }
}

