/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.domain.connection.oracle;

import java.sql.Connection;
import java.util.Optional;
import javax.sql.DataSource;
import org.mule.extension.db.internal.domain.connection.DataSourceConfig;
import org.mule.extension.db.internal.domain.connection.DbConnection;
import org.mule.extension.db.internal.domain.connection.DbConnectionProvider;
import org.mule.extension.db.internal.domain.connection.oracle.OracleConnectionParameters;
import org.mule.extension.db.internal.domain.connection.oracle.OracleDbConnection;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;

@DisplayName(value="Oracle Connection")
@Alias(value="oracle")
public class OracleDbConnectionProvider
extends DbConnectionProvider {
    @ParameterGroup(value="Connection")
    private OracleConnectionParameters oracleConnectionParameters;

    @Override
    protected DbConnection createDbConnection(Connection connection) throws Exception {
        return new OracleDbConnection(connection, super.resolveCustomTypes());
    }

    @Override
    public Optional<DataSource> getDataSource() {
        return Optional.empty();
    }

    @Override
    public Optional<DataSourceConfig> getDataSourceConfig() {
        return Optional.ofNullable(this.oracleConnectionParameters);
    }
}

